/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.common.crafting.recipes.IDyeable;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import org.jetbrains.annotations.NotNull;

public class DyeRecipe
extends ShapelessRecipe {
    public DyeRecipe(String groupIn, CraftingBookCategory category, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(groupIn, CraftingBookCategory.MISC, recipeOutputIn, recipeItemsIn);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput inv, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider p_266797_) {
        ItemStack output = super.assemble(inv, p_266797_);
        if (!output.isEmpty()) {
            ItemStack ingredient;
            int i;
            for (i = 0; i < inv.size(); ++i) {
                ingredient = inv.getItem(i);
                if (ingredient.isEmpty() || !(ingredient.getItem() instanceof IDyeable)) continue;
                output.applyComponents(ingredient.getComponentsPatch());
            }
            for (i = 0; i < inv.size(); ++i) {
                Item item;
                ingredient = inv.getItem(i);
                DyeColor color = DyeColor.getColor((ItemStack)ingredient);
                if (ingredient.isEmpty() || color == null || !((item = output.getItem()) instanceof IDyeable)) continue;
                IDyeable dyeable = (IDyeable)item;
                dyeable.onDye(output, color);
            }
        }
        return output;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.DYE_RECIPE.get();
    }
}

