/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.RuneCaster;
import com.hollingsworth.arsnouveau.api.util.IWololoable;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.RuneBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RuneTile
extends ModdedTile
implements GeoBlockEntity,
ITickable,
ITooltipProvider,
IWololoable {
    public Spell spell = new Spell();
    public boolean isTemporary = false;
    public boolean disabled = false;
    public boolean isCharged = true;
    public boolean isSensitive;
    public int ticksUntilCharge = 0;
    public UUID uuid = null;
    public Entity touchedEntity;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RuneTile(BlockPos pos, BlockState state) {
        super(BlockRegistry.RUNE_TILE, pos, state);
    }

    public void setSpell(Spell spell) {
        this.spell = spell;
        this.updateBlock();
    }

    public void castSpell(Entity entity) {
        ServerLevel serverLevel;
        block10: {
            block9: {
                Level level;
                if (entity == null) {
                    return;
                }
                if (!this.isCharged || this.spell.isEmpty() || !((level = this.level) instanceof ServerLevel)) break block9;
                serverLevel = (ServerLevel)level;
                if (this.spell.get(0) instanceof MethodTouch) break block10;
            }
            return;
        }
        if (!this.isTemporary && this.disabled) {
            return;
        }
        try {
            ServerPlayer onlinePlayer;
            ANFakePlayer playerEntity;
            ANFakePlayer aNFakePlayer = playerEntity = this.uuid != null ? FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)new GameProfile(this.uuid, "")) : ANFakePlayer.getPlayer(serverLevel);
            if (this.isSensitive && (onlinePlayer = serverLevel.getServer().getPlayerList().getPlayer(this.uuid)) != null) {
                playerEntity = onlinePlayer;
            }
            EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(entity.level, this.spell, (LivingEntity)playerEntity, new RuneCaster(this, SpellContext.CasterType.RUNE)));
            resolver.onCastOnEntity(ItemStack.EMPTY, entity, InteractionHand.MAIN_HAND);
            if (this.isTemporary) {
                this.level.destroyBlock(this.worldPosition, false);
                return;
            }
            this.isCharged = false;
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).cycle((Property)RuneBlock.POWERED));
            this.ticksUntilCharge = 40;
            this.updateBlock();
        }
        catch (Exception e) {
            PortUtil.sendMessage(entity, (Component)Component.translatable((String)"ars_nouveau.rune.error"));
            e.printStackTrace();
            this.level.destroyBlock(this.worldPosition, false);
        }
    }

    public void setPlayer(UUID uuid) {
        this.uuid = uuid;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.put("spell", ANCodecs.encode(Spell.CODEC.codec(), this.spell));
        tag.putBoolean("charged", this.isCharged);
        tag.putBoolean("redstone", this.disabled);
        tag.putBoolean("temp", this.isTemporary);
        tag.putInt("cooldown", this.ticksUntilCharge);
        if (this.uuid != null) {
            tag.putUUID("uuid", this.uuid);
        }
        tag.putBoolean("sensitive", this.isSensitive);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.spell = (Spell)ANCodecs.decode(Spell.CODEC.codec(), (Tag)tag.getCompound("spell"));
        this.isCharged = tag.getBoolean("charged");
        this.disabled = tag.getBoolean("redstone");
        this.isTemporary = tag.getBoolean("temp");
        this.ticksUntilCharge = tag.getInt("cooldown");
        if (tag.contains("uuid")) {
            this.uuid = tag.getUUID("uuid");
        }
        this.isSensitive = tag.getBoolean("sensitive");
    }

    @Override
    public void tick() {
        if (this.level == null) {
            return;
        }
        if (!this.level.isClientSide && --this.ticksUntilCharge > 0) {
            return;
        }
        if (this.isCharged) {
            return;
        }
        if (!this.level.isClientSide && this.isTemporary) {
            this.level.destroyBlock(this.worldPosition, false);
        }
        if (!this.level.isClientSide) {
            List<ISpecialSourceProvider> provider = SourceUtil.takeSourceMultipleWithParticles(this.worldPosition, this.level, 10, this.spell.getCost());
            if (provider != null) {
                this.isCharged = true;
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.level.getBlockState(this.worldPosition).cycle((Property)RuneBlock.POWERED));
                this.updateBlock();
            } else {
                this.ticksUntilCharge = 60;
                this.updateBlock();
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    @Override
    public void getTooltip(List<Component> tooltip) {
        if (ArsNouveau.proxy.getPlayer().hasEffect(ModPotions.MAGIC_FIND_EFFECT)) {
            tooltip.add((Component)Component.literal((String)this.spell.getDisplayString()));
        }
    }

    @Override
    public void setColor(ParticleColor color) {
        this.spell = this.spell.withColor(color);
        this.updateBlock();
    }

    @Override
    public ParticleColor getColor() {
        return this.spell.color();
    }
}

