/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.RelayTile;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RelayDepositTile
extends RelayTile {
    public RelayDepositTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.RELAY_DEPOSIT_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.disabled) {
            return;
        }
        if (!this.level.isClientSide && this.level.getGameTime() % 20L == 0L && this.getSource() > 0) {
            List<ISpecialSourceProvider> posList = SourceUtil.canGiveSource(this.worldPosition, this.level, 5);
            for (ISpecialSourceProvider provider : posList) {
                if (this.getSource() <= 0) break;
                if (this.getToPos() != null && this.level.isLoaded(this.getToPos()) && this.level.getBlockEntity(this.getToPos()) == provider.getSource() || this.getFromPos() != null && this.level.isLoaded(this.getFromPos()) && this.level.getBlockEntity(this.getFromPos()) == provider.getSource() || provider.getSource() instanceof RelayTile) continue;
                this.transferSource(this, provider.getSource());
                ParticleUtil.spawnFollowProjectile(this.level, this.worldPosition, provider.getCurrentPos(), this.getColor());
            }
        }
    }
}

