/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.client.container.CraftingTerminalMenu;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.common.block.tile.StorageLecternTile;
import com.hollingsworth.arsnouveau.common.block.tile.TransientCustomContainer;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.SetTerminalSettingsPacket;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CraftingLecternTile
extends StorageLecternTile
implements GeoBlockEntity {
    private Function<UUID, AbstractContainerMenu> craftingContainer = uuid -> new AbstractContainerMenu(MenuType.CRAFTING, 0, (UUID)uuid){
        final /* synthetic */ UUID val$uuid;
        {
            this.val$uuid = uUID;
            super(arg0, arg1);
        }

        public boolean stillValid(Player player) {
            return false;
        }

        public void slotsChanged(Container inventory) {
            if (CraftingLecternTile.this.level != null && !((CraftingLecternTile)CraftingLecternTile.this).level.isClientSide && this.val$uuid != null) {
                CraftingLecternTile.this.onCraftingMatrixChanged(this.val$uuid);
            }
        }

        public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
            return ItemStack.EMPTY;
        }
    };
    private CraftingRecipe currentRecipe;
    private final TransientCustomContainer legacyCraftMatrix = new TransientCustomContainer(this.craftingContainer.apply(null), 3, 3);
    public final Map<UUID, TransientCustomContainer> craftingMatrices = new HashMap<UUID, TransientCustomContainer>();
    private final Map<UUID, ResultContainer> craftingResults = new HashMap<UUID, ResultContainer>();
    private HashSet<CraftingTerminalMenu> craftingListeners = new HashSet();
    private boolean reading;
    AnimatableInstanceCache AnimatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public CraftingLecternTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockRegistry.CRAFTING_LECTERN_TILE.get(), pos, state);
    }

    @Override
    public AbstractContainerMenu createMenu(int id, Inventory plInv, Player arg2) {
        return new CraftingTerminalMenu(id, plInv, this);
    }

    private ListTag getCraftMatrixTag(TransientCustomContainer craftingMatrix, HolderLookup.Provider pRegistries) {
        ListTag listTag = new ListTag();
        for (int i = 0; i < craftingMatrix.getContainerSize(); ++i) {
            ItemStack itemstack = craftingMatrix.getItem(i);
            if (itemstack.isEmpty()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putInt("Slot", i);
            compoundTag.put("item", itemstack.save(pRegistries));
            listTag.add((Object)compoundTag);
        }
        return listTag;
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        if (this.legacyCraftMatrix != null && !this.legacyCraftMatrix.isEmpty()) {
            tag.put("CraftingTable", (Tag)this.getCraftMatrixTag(this.legacyCraftMatrix, pRegistries));
        }
        ListTag matrices = new ListTag();
        for (Map.Entry<UUID, TransientCustomContainer> entry : this.craftingMatrices.entrySet()) {
            UUID uuid = entry.getKey();
            CompoundTag matrix = new CompoundTag();
            matrix.putUUID("UUID", uuid);
            matrix.put("CraftingTable", (Tag)this.getCraftMatrixTag(entry.getValue(), pRegistries));
            matrices.add((Object)matrix);
        }
        tag.put("CraftingMatrices", (Tag)matrices);
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.reading = true;
        ListTag matrices = compound.getList("CraftingMatrices", 10);
        for (int i = 0; i < matrices.size(); ++i) {
            CompoundTag entry = matrices.getCompound(i);
            UUID uuid = entry.getUUID("UUID");
            TransientCustomContainer container = this.getCraftingInv(uuid);
            ListTag table = entry.getList("CraftingTable", 10);
            for (int j = 0; j < table.size(); ++j) {
                CompoundTag itemSlot = table.getCompound(j);
                int slot = itemSlot.getInt("Slot");
                if (slot < 0 || slot >= container.getContainerSize()) continue;
                container.setItem(slot, ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)itemSlot.getCompound("item")));
            }
        }
        ListTag listTag = compound.getList("CraftingTable", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.getCompound(i);
            int j = compoundTag.getInt("Slot");
            if (j < 0 || j >= this.legacyCraftMatrix.getContainerSize()) continue;
            this.legacyCraftMatrix.setItem(j, ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)compoundTag.getCompound("item")));
        }
        this.reading = false;
    }

    public TransientCustomContainer getCraftingInv(Player player) {
        return this.getCraftingInv(player.getUUID());
    }

    public NonNullList<ItemStack> getInitialInventory(int width, int height) {
        NonNullList inventory = NonNullList.withSize((int)(width * height), (Object)ItemStack.EMPTY);
        if (!this.legacyCraftMatrix.isEmpty()) {
            for (int i = 0; i < this.legacyCraftMatrix.getContainerSize(); ++i) {
                ItemStack itemstack = this.legacyCraftMatrix.getItem(i);
                inventory.set(i, (Object)itemstack);
                this.legacyCraftMatrix.setItem(i, ItemStack.EMPTY);
            }
        }
        return inventory;
    }

    public TransientCustomContainer getCraftingInv(UUID uuid) {
        NonNullList<ItemStack> initialInventory = this.getInitialInventory(3, 3);
        return this.craftingMatrices.computeIfAbsent(uuid, key -> new TransientCustomContainer(this.craftingContainer.apply(uuid), 3, 3, initialInventory));
    }

    public ResultContainer getCraftResult(Player player) {
        return this.getCraftResult(player.getUUID());
    }

    public ResultContainer getCraftResult(UUID uuid) {
        return this.craftingResults.computeIfAbsent(uuid, key -> new ResultContainer());
    }

    public void craftShift(ServerPlayer player, @Nullable String tab) {
        ResultContainer craftResult = this.getCraftResult((Player)player);
        TransientCustomContainer craftMatrix = this.getCraftingInv((Player)player);
        ArrayList<ItemStack> craftedItemsList = new ArrayList<ItemStack>();
        int amountCrafted = 0;
        ItemStack crafted = craftResult.getItem(0);
        do {
            this.craft(player, tab);
            craftedItemsList.add(crafted.copy());
        } while (ItemStack.isSameItem((ItemStack)crafted, (ItemStack)craftResult.getItem(0)) && (amountCrafted += crafted.getCount()) + crafted.getCount() <= crafted.getMaxStackSize());
        for (ItemStack craftedItem : craftedItemsList) {
            ItemStack is;
            if (player.getInventory().add(craftedItem.copy()) || (is = this.pushStack(craftedItem, tab)).isEmpty()) continue;
            Containers.dropItemStack((Level)this.level, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)is);
        }
        crafted.onCraftedBy(player.level, (Player)player, amountCrafted);
        ItemStack copyStack = crafted.copy();
        copyStack.setCount(amountCrafted);
        EventHooks.firePlayerCraftingEvent((Player)player, (ItemStack)copyStack, (Container)craftMatrix);
    }

    public void craft(ServerPlayer thePlayer, @Nullable String tab) {
        TransientCustomContainer craftMatrix = this.getCraftingInv((Player)thePlayer);
        if (this.currentRecipe == null) {
            return;
        }
        boolean playerInvUpdate = false;
        NonNullList remainingItems = this.currentRecipe.getRemainingItems((RecipeInput)craftMatrix.asCraftInput());
        for (int i = 0; i < 9; ++i) {
            ItemStack rem;
            ItemStack currentStack = craftMatrix.getItem(i);
            ItemStack oldItem = currentStack.copy();
            ItemStack itemStack = rem = remainingItems.size() > i ? (ItemStack)remainingItems.get(i) : ItemStack.EMPTY;
            if (!currentStack.isEmpty()) {
                craftMatrix.removeItemNoUpdate(i, 1);
                currentStack = craftMatrix.getItem(i);
            }
            if (currentStack.isEmpty() && !oldItem.isEmpty()) {
                StoredItemStack is = this.pullStack(new StoredItemStack(oldItem), 1, tab);
                if (is == null) {
                    for (int j = 0; j < thePlayer.getInventory().getContainerSize(); ++j) {
                        ItemStack st = thePlayer.getInventory().getItem(j);
                        if (!ItemStack.isSameItem((ItemStack)oldItem, (ItemStack)st) || !ItemStack.matches((ItemStack)oldItem, (ItemStack)st) || (st = thePlayer.getInventory().removeItem(j, 1)).isEmpty()) continue;
                        is = new StoredItemStack(st, 1L);
                        playerInvUpdate = true;
                        break;
                    }
                }
                if (is != null) {
                    craftMatrix.setItemNoUpdate(i, is.getActualStack());
                    currentStack = craftMatrix.getItem(i);
                }
            }
            if (rem.isEmpty()) continue;
            if (currentStack.isEmpty()) {
                craftMatrix.setItemNoUpdate(i, rem);
                continue;
            }
            if (ItemStack.isSameItem((ItemStack)currentStack, (ItemStack)rem) && ItemStack.matches((ItemStack)currentStack, (ItemStack)rem)) {
                rem.grow(currentStack.getCount());
                craftMatrix.setItemNoUpdate(i, rem);
                continue;
            }
            if ((rem = this.pushStack(rem, tab)).isEmpty() || thePlayer.getInventory().add(rem)) continue;
            thePlayer.drop(rem, false);
        }
        if (playerInvUpdate) {
            thePlayer.containerMenu.broadcastChanges();
        }
        this.onCraftingMatrixChanged(thePlayer.getUUID());
    }

    public void unregisterCrafting(CraftingTerminalMenu containerCraftingTerminal) {
        this.craftingListeners.remove(containerCraftingTerminal);
    }

    public void registerCrafting(CraftingTerminalMenu containerCraftingTerminal) {
        this.craftingListeners.add(containerCraftingTerminal);
    }

    protected void onCraftingMatrixChanged(UUID uuid) {
        if (this.sortSettings.expanded()) {
            this.setSorting(this.sortSettings.setExpanded(false));
            Player player = this.level.getPlayerByUUID(uuid);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Networking.sendToPlayerClient(new SetTerminalSettingsPacket(this.sortSettings, (String)this.searches.get(uuid)), serverPlayer);
            }
        }
        ResultContainer craftResult = this.getCraftResult(uuid);
        TransientCustomContainer craftMatrix = this.getCraftingInv(uuid);
        if (this.currentRecipe == null || !this.currentRecipe.matches((RecipeInput)craftMatrix.asCraftInput(), this.level)) {
            RecipeHolder holder = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftMatrix.asCraftInput(), this.level).orElse(null);
            CraftingRecipe craftingRecipe = this.currentRecipe = holder == null ? null : (CraftingRecipe)holder.value();
        }
        if (this.currentRecipe == null) {
            craftResult.setItem(0, ItemStack.EMPTY);
        } else {
            craftResult.setItem(0, this.currentRecipe.assemble((RecipeInput)craftMatrix.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()));
        }
        this.craftingListeners.forEach(CraftingTerminalMenu::onCraftMatrixChanged);
        if (!this.reading) {
            this.setChanged();
        }
    }

    public void clear(Player player, @Nullable String tab) {
        TransientCustomContainer craftMatrix = this.getCraftingInv(player);
        for (int i = 0; i < craftMatrix.getContainerSize(); ++i) {
            ItemStack st = craftMatrix.removeItemNoUpdate(i);
            if (st.isEmpty()) continue;
            this.pushOrDrop(st, tab);
        }
        this.onCraftingMatrixChanged(player.getUUID());
    }

    public void transferToGrid(Player player, ItemStack[][] ingredients, @Nullable String tab) {
        this.clear(player, tab);
        TransientCustomContainer craftMatrix = this.getCraftingInv(player);
        for (int i = 0; i < 9; ++i) {
            ItemStack[] ingredient = ingredients[i];
            if (ingredient == null) continue;
            ItemStack stack = ItemStack.EMPTY;
            for (ItemStack itemStack : ingredient) {
                boolean br = false;
                Inventory playerInv = player.getInventory();
                for (int k = 0; k < playerInv.getContainerSize(); ++k) {
                    if (!ItemStack.isSameItem((ItemStack)playerInv.getItem(k), (ItemStack)itemStack)) continue;
                    stack = playerInv.removeItem(k, 1);
                    br = true;
                    break;
                }
                if (br) break;
            }
            if (stack.isEmpty()) {
                Map inv = this.itemCounts;
                for (ItemStack itemStack : ingredient = (ItemStack[])Arrays.stream(ingredient).filter(Objects::nonNull).sorted(Comparator.comparingLong(a -> inv.getOrDefault(((ItemStack)a).getItem(), 0L)).reversed()).toArray(ItemStack[]::new)) {
                    ItemStack pulled = this.pullStack(itemStack, tab);
                    if (pulled.isEmpty()) continue;
                    stack = pulled;
                    break;
                }
            }
            if (stack.isEmpty()) continue;
            craftMatrix.setItem(i, stack);
        }
        this.onCraftingMatrixChanged(player.getUUID());
    }

    private ItemStack pullStack(ItemStack itemStack, @Nullable String tab) {
        StoredItemStack is = this.pullStack(new StoredItemStack(itemStack), 1, tab);
        if (is == null) {
            return ItemStack.EMPTY;
        }
        return is.getActualStack();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "controller", 1, event -> {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("ledger_float"));
            return PlayState.CONTINUE;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.AnimatableInstanceCache;
    }
}

