/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.recipe.MultiRecipeWrapper;
import com.hollingsworth.arsnouveau.common.block.SummonBlock;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WixieCauldron
extends SummonBlock {
    public static final VoxelShape shape = Stream.of(Block.box((double)2.0, (double)0.0, (double)4.0, (double)4.0, (double)13.0, (double)14.0), Block.box((double)4.0, (double)0.0, (double)12.0, (double)14.0, (double)13.0, (double)14.0), Block.box((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)12.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)12.0, (double)13.0, (double)4.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0), Block.box((double)14.0, (double)0.0, (double)5.0, (double)16.0, (double)4.0, (double)16.0), Block.box((double)14.0, (double)4.0, (double)9.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)9.0, (double)0.0, (double)14.0, (double)14.0, (double)4.0, (double)16.0), Block.box((double)2.0, (double)0.0, (double)14.0, (double)7.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)11.0, (double)2.0, (double)4.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)9.0, (double)7.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)9.0, (double)2.0), Block.box((double)2.0, (double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)2.0), Block.box((double)7.0, (double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)2.0), Block.box((double)9.0, (double)4.0, (double)14.0, (double)14.0, (double)8.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final BooleanProperty FILLED = BooleanProperty.create((String)"filled");

    public WixieCauldron() {
        super(WixieCauldron.defaultProperties().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)SummoningTile.CONVERTED, (Comparable)Boolean.valueOf(false))).setValue((Property)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return shape;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (worldIn.isClientSide || handIn != InteractionHand.MAIN_HAND || !(worldIn.getBlockEntity(pos) instanceof WixieCauldronTile) || player.getMainHandItem().getItem() == ItemsRegistry.DOMINION_ROD.get()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player.getMainHandItem().getItem() != ItemsRegistry.WIXIE_CHARM.get() && !player.getMainHandItem().isEmpty() && (blockEntity = worldIn.getBlockEntity(pos)) instanceof WixieCauldronTile) {
            WixieCauldronTile cauldronTile = (WixieCauldronTile)blockEntity;
            MultiRecipeWrapper wrapper = cauldronTile.getRecipesForStack(player.getMainHandItem());
            if (wrapper.isEmpty()) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.wixie.no_recipe"));
            } else {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.wixie.recipe_set"));
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FILLED});
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(state, world, pos, blockIn, fromPos, isMoving);
        if (!world.isClientSide() && (blockEntity = world.getBlockEntity(pos)) instanceof WixieCauldronTile) {
            WixieCauldronTile cauldronTile = (WixieCauldronTile)blockEntity;
            cauldronTile.isOff = world.hasNeighborSignal(pos);
            cauldronTile.updateBlock();
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WixieCauldronTile(pos, state);
    }
}

