/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block;

import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.common.block.TableBlock;
import com.hollingsworth.arsnouveau.common.block.ThreePartBlock;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.items.DominionWand;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOpenGlyphCraft;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ScribesBlock
extends TableBlock {
    public ScribesBlock() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (world.isClientSide || handIn != InteractionHand.MAIN_HAND || !((blockEntity = world.getBlockEntity(pos)) instanceof ScribesTile)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ScribesTile tile = (ScribesTile)blockEntity;
        if (player.getItemInHand(handIn).getItem() instanceof SpellBook && !player.isShiftKeyDown()) {
            Networking.sendToPlayerClient(new PacketOpenGlyphCraft(pos), (ServerPlayer)player);
            return ItemInteractionResult.SUCCESS;
        }
        if (state.getValue((Property)PART) != ThreePartBlock.HEAD) {
            BlockEntity tileEntity = world.getBlockEntity(pos.relative(ScribesBlock.getConnectedDirection(state)));
            ScribesTile scribesTile = tile = tileEntity instanceof ScribesTile ? (ScribesTile)tileEntity : null;
            if (tile == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
        }
        if (!player.isShiftKeyDown()) {
            if (tile.consumeStack(player.getItemInHand(handIn))) {
                return ItemInteractionResult.SUCCESS;
            }
            if (!tile.getStack().isEmpty() && player.getItemInHand(handIn).isEmpty()) {
                item = new ItemEntity(world, player.getX(), player.getY(), player.getZ(), tile.getStack());
                world.addFreshEntity((Entity)item);
                tile.setStack(ItemStack.EMPTY);
            } else if (!player.getInventory().getSelected().isEmpty()) {
                if (!tile.getStack().isEmpty()) {
                    item = new ItemEntity(world, player.getX(), player.getY(), player.getZ(), tile.getStack());
                    world.addFreshEntity((Entity)item);
                }
                tile.setStack(player.getInventory().removeItem(player.getInventory().selected, 1));
            }
            BlockState updateState = world.getBlockState(tile.getBlockPos());
            world.sendBlockUpdated(tile.getBlockPos(), updateState, updateState, 2);
        }
        if (player.isShiftKeyDown()) {
            ItemStack stack = tile.getStack();
            if (player.getItemInHand(handIn).getItem() instanceof DominionWand) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (stack == null || stack.isEmpty()) {
                return ItemInteractionResult.SUCCESS;
            }
            Item item = stack.getItem();
            if (item instanceof IScribeable) {
                IScribeable scribeable = (IScribeable)item;
                scribeable.onScribe(world, pos, player, handIn, stack);
                BlockState updateState = world.getBlockState(tile.getBlockPos());
                world.sendBlockUpdated(tile.getBlockPos(), updateState, updateState, 2);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        ScribesTile tile;
        super.playerWillDestroy(worldIn, pos, state, player);
        BlockEntity blockEntity = worldIn.getBlockEntity(pos);
        if (blockEntity instanceof ScribesTile && (tile = (ScribesTile)blockEntity).getStack() != null) {
            worldIn.addFreshEntity((Entity)new ItemEntity(worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), tile.getStack()));
            tile.refundConsumed();
        }
        return state;
    }

    @Override
    public BlockState tearDown(BlockState state, Direction direction, BlockState state2, LevelAccessor world, BlockPos pos, BlockPos pos2) {
        BlockEntity entity;
        if (!world.isClientSide() && (entity = world.getBlockEntity(pos)) instanceof ScribesTile) {
            ScribesTile tile = (ScribesTile)entity;
            if (((ScribesTile)entity).getStack() != null) {
                world.addFreshEntity((Entity)new ItemEntity((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ((ScribesTile)entity).getStack()));
                tile.refundConsumed();
            }
        }
        return Blocks.AIR.defaultBlockState();
    }

    @SubscribeEvent
    public void rightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (!(event.getLevel().getBlockEntity(event.getPos()) instanceof ScribesTile)) {
            return;
        }
        Level world = event.getLevel();
        if (world.getBlockState(pos = event.getPos()).getBlock() instanceof ScribesBlock) {
            ItemStack stack = event.getEntity().getItemInHand(event.getHand());
            if (stack.getItem() instanceof DominionWand) {
                return;
            }
            ((ScribesBlock)BlockRegistry.SCRIBES_BLOCK.get()).useItemOn(stack, world.getBlockState(pos), world, pos, event.getEntity(), event.getHand(), null);
            event.setCanceled(true);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ScribesTile(pos, state);
    }

    public boolean isPathfindable(BlockState pState, PathComputationType pType) {
        return false;
    }
}

