/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.renderer.item.GenericItemBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.ArsGeoBlockRenderer;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.util.Color;

public class RuneRenderer
extends ArsGeoBlockRenderer<RuneTile> {
    public static GenericModel model = new GenericModel("rune");

    public RuneRenderer(BlockEntityRendererProvider.Context rendererDispatcherIn) {
        super(rendererDispatcherIn, model);
    }

    public void preRender(PoseStack poseStack, RuneTile animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
    }

    public void renderFinal(PoseStack poseStack, RuneTile animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, int color) {
    }

    @Override
    public void actuallyRender(PoseStack poseStack, RuneTile animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        ParticleColor particleColor = animatable.spell.color();
        poseStack.pushPose();
        Direction direction = (Direction)animatable.getBlockState().getValue((Property)BasicSpellTurret.FACING);
        if (direction == Direction.UP) {
            poseStack.translate(0.5, 0.0, 0.5);
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        } else if (direction == Direction.EAST) {
            poseStack.translate(0.0, 0.5, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        } else if (direction == Direction.NORTH) {
            poseStack.translate(0.5, 0.5, 1.0);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        } else if (direction == Direction.DOWN) {
            poseStack.translate(0.5, 0.98, 0.5);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        } else if (direction == Direction.WEST) {
            poseStack.translate(1.0, 0.5, 0.5);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        } else if (direction == Direction.SOUTH) {
            poseStack.translate(0.5, 0.5, 0.0);
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-180.0f));
        }
        super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        poseStack.popPose();
    }

    public RenderType getRenderType(RuneTile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityCutoutNoCull((ResourceLocation)texture);
    }

    public Color getRenderColor(RuneTile animatable, float partialTick, int packedLight) {
        ParticleColor color = animatable.spell.color();
        return animatable.isCharged ? Color.ofOpaque((int)color.getColor()) : super.getRenderColor((GeoAnimatable)animatable, partialTick, packedLight);
    }

    public static GenericItemBlockRenderer getISTER() {
        return new GenericItemBlockRenderer(model);
    }
}

