/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.registry.FamiliarRegistry;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.client.gui.GuiUtils;
import com.hollingsworth.arsnouveau.client.gui.NoShadowTextField;
import com.hollingsworth.arsnouveau.client.gui.SchoolTooltip;
import com.hollingsworth.arsnouveau.client.gui.book.BaseBook;
import com.hollingsworth.arsnouveau.client.gui.book.GuiColorScreen;
import com.hollingsworth.arsnouveau.client.gui.book.GuiFamiliarScreen;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSettingsScreen;
import com.hollingsworth.arsnouveau.client.gui.book.SoundScreen;
import com.hollingsworth.arsnouveau.client.gui.buttons.CraftingButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.CreateSpellButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GlyphButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiSpellSlot;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateCaster;
import com.hollingsworth.arsnouveau.common.spell.validation.CombinedSpellValidator;
import com.hollingsworth.arsnouveau.common.spell.validation.GlyphMaxTierValidator;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class GuiSpellBook
extends BaseBook {
    public int numLinks = 10;
    public int selectedSpellSlot = 0;
    public EditBox spell_name;
    public NoShadowTextField searchBar;
    public GuiSpellSlot selected_slot;
    public List<CraftingButton> craftingCells = new ArrayList<CraftingButton>();
    public List<AbstractSpellPart> unlockedSpells;
    public List<AbstractSpellPart> displayedGlyphs;
    public List<GlyphButton> glyphButtons = new ArrayList<GlyphButton>();
    public int page = 0;
    public PageButton nextButton;
    public PageButton previousButton;
    public ISpellValidator spellValidator;
    public String previousString = "";
    public ItemStack bookStack;
    public int formTextRow = 0;
    public int augmentTextRow = 0;
    public int effectTextRow = 0;
    public int glyphsPerPage = 58;
    public InteractionHand hand;
    public int maxManaCache = 0;
    int currentCostCache = 0;
    public CreateSpellButton createSpellButton;
    public Renderable hoveredWidget = null;
    public List<AbstractSpellPart> spell = new ArrayList<AbstractSpellPart>();
    public PageButton nextGlyphButton;
    public PageButton prevGlyphButton;
    public int spellWindowOffset = 0;
    public int bonusSlots = 0;
    public String spellname = "";
    public AbstractCaster<?> caster;
    public long timeOpened;

    public GuiSpellBook(InteractionHand hand) {
        AbstractCaster<?> caster;
        this.hand = hand;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ANPlayerDataCap cap = CapabilityRegistry.getPlayerDataCap((LivingEntity)player);
        ItemStack heldStack = player.getItemInHand(hand);
        ArrayList<AbstractSpellPart> parts = cap == null ? new ArrayList<AbstractSpellPart>() : new ArrayList<AbstractSpellPart>(cap.getKnownGlyphs().stream().filter(AbstractSpellPart::shouldShowInSpellBook).toList());
        this.maxManaCache = ManaUtil.getMaxMana((Player)player);
        parts.addAll(GlyphRegistry.getDefaultStartingSpells());
        int tier = 1;
        Item item = heldStack.getItem();
        if (item instanceof SpellBook) {
            SpellBook book = (SpellBook)item;
            tier = book.getTier().value;
            if (book.getTier() == SpellTier.CREATIVE) {
                parts = new ArrayList<AbstractSpellPart>(GlyphRegistry.getSpellpartMap().values().stream().filter(AbstractSpellPart::shouldShowInSpellBook).toList());
            }
        }
        if (SpellCasterRegistry.hasCaster(heldStack) && (caster = SpellCasterRegistry.from(heldStack)) != null) {
            this.bonusSlots = caster.getBonusGlyphSlots();
        }
        this.bookStack = heldStack;
        this.unlockedSpells = parts;
        this.displayedGlyphs = new ArrayList<AbstractSpellPart>(this.unlockedSpells);
        this.validationErrors = new LinkedList();
        this.spellValidator = new CombinedSpellValidator(ArsNouveauAPI.getInstance().getSpellCraftingSpellValidator(), new GlyphMaxTierValidator(tier));
        this.caster = SpellCasterRegistry.from(this.bookStack);
        this.selectedSpellSlot = this.caster.getCurrentSlot();
        this.spellname = this.caster.getSpellName(this.caster.getCurrentSlot());
        List<AbstractSpellPart> recipe = SpellCasterRegistry.from((ItemStack)this.bookStack).getSpell((int)this.selectedSpellSlot).mutable().recipe;
        this.spell = new ArrayList<AbstractSpellPart>(recipe);
    }

    public void onBookstackUpdated(ItemStack stack) {
        this.bookStack = stack;
        this.caster = SpellCasterRegistry.from(stack);
        if (this.caster == null) {
            Minecraft.getInstance().setScreen(null);
        }
    }

    @Override
    public void init() {
        super.init();
        this.timeOpened = System.currentTimeMillis();
        this.craftingCells = new ArrayList<CraftingButton>();
        this.resetCraftingCells();
        this.layoutAllGlyphs(this.page);
        this.createSpellButton = (CreateSpellButton)this.addRenderableWidget((GuiEventListener)new CreateSpellButton(this.bookRight - 71, this.bookBottom - 11, this::onCreateClick, () -> !this.validationErrors.isEmpty()));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookRight - 126, this.bookBottom - 11, 0, 0, 41, 12, 41, 12, "textures/gui/clear_icon.png", this::clear));
        this.spell_name = new NoShadowTextField(this.minecraft.font, this.bookLeft + 32, this.bookBottom - 9, 88, 12, null, (Component)Component.translatable((String)"ars_nouveau.spell_book_gui.spell_name"));
        this.spell_name.setBordered(false);
        this.spell_name.setTextColor(12694931);
        this.searchBar = new NoShadowTextField(this.minecraft.font, this.bookRight - 73, this.bookTop, 54, 12, null, (Component)Component.translatable((String)"ars_nouveau.spell_book_gui.search"));
        this.searchBar.setBordered(false);
        this.searchBar.setTextColor(12694931);
        this.searchBar.onClear = val -> {
            this.onSearchChanged("");
            return null;
        };
        this.spell_name.setValue(this.spellname);
        if (this.spell_name.getValue().isEmpty()) {
            this.spell_name.setSuggestion(Component.translatable((String)"ars_nouveau.spell_book_gui.spell_name").getString());
        }
        if (this.searchBar.getValue().isEmpty()) {
            this.searchBar.setSuggestion(Component.translatable((String)"ars_nouveau.spell_book_gui.search").getString());
        }
        this.searchBar.setResponder(this::onSearchChanged);
        this.addRenderableWidget((GuiEventListener)this.spell_name);
        this.addRenderableWidget((GuiEventListener)this.searchBar);
        for (int i2 = 0; i2 < 10; ++i2) {
            String name = this.caster.getSpellName(i2);
            GuiSpellSlot slot = new GuiSpellSlot(this.bookLeft + 281, this.bookTop - 1 + 15 * (i2 + 1), i2, name, this::onSlotChange);
            if (i2 == this.selectedSpellSlot) {
                this.selected_slot = slot;
                slot.isSelected = true;
            }
            this.addRenderableWidget((GuiEventListener)slot);
        }
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 22, 0, 0, 23, 20, 23, 20, "textures/gui/worn_book_bookmark.png", this::onDocumentationClick).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.notebook")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 44, 0, 0, 23, 20, 23, 20, "textures/gui/color_wheel_bookmark.png", this::onColorClick).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.color")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 68, 0, 0, 23, 20, 23, 20, "textures/gui/summon_circle_bookmark.png", this::onFamiliarClick).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.familiar")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 92, 0, 0, 23, 20, 23, 20, "textures/gui/sounds_tab.png", this::onSoundsClick).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.sounds")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 116, 0, 0, 23, 20, 23, 20, "textures/gui/settings_tab.png", b -> Minecraft.getInstance().setScreen((Screen)new GuiSettingsScreen(this))).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.settings")));
        this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.bookLeft - 15, this.bookTop + 140, 0, 0, 23, 20, 23, 20, "textures/gui/discord_tab.png", b -> {
            try {
                Util.getPlatform().openUri(new URI("https://discord.com/invite/y7TMXZu"));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }).withTooltip((Component)Component.translatable((String)"ars_nouveau.gui.discord")));
        this.nextButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.bookRight - 20, this.bookBottom - 6, true, this::onPageIncrease, true));
        this.previousButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.bookLeft - 5, this.bookBottom - 6, false, this::onPageDec, true));
        this.updateNextPageButtons();
        this.previousButton.active = false;
        this.previousButton.visible = false;
        if (this.getExtraGlyphSlots() > 0) {
            this.nextGlyphButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.bookRight - 25, this.bookBottom - 26, true, i -> this.updateWindowOffset(this.spellWindowOffset + 1), true));
            this.prevGlyphButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.bookLeft, this.bookBottom - 26, false, i -> this.updateWindowOffset(this.spellWindowOffset - 1), true));
            this.updateWindowOffset(0);
        }
        this.validate();
    }

    public int getNumPages() {
        return (int)Math.ceil((double)this.displayedGlyphs.size() / 58.0);
    }

    private void layoutAllGlyphs(int page) {
        this.clearButtons(this.glyphButtons);
        this.formTextRow = 0;
        this.augmentTextRow = 0;
        this.effectTextRow = 0;
        if (this.displayedGlyphs.isEmpty()) {
            return;
        }
        int PER_ROW = 6;
        int MAX_ROWS = 6;
        boolean nextPage = false;
        int xStart = nextPage ? this.bookLeft + 154 : this.bookLeft + 20;
        int adjustedRowsPlaced = 0;
        boolean foundForms = false;
        boolean foundAugments = false;
        boolean foundEffects = false;
        List<AbstractSpellPart> sorted = new ArrayList<AbstractSpellPart>(this.displayedGlyphs);
        sorted.sort(Comparator.comparingInt(p -> {
            AbstractSpellPart abstractSpellPart = p;
            Objects.requireNonNull(abstractSpellPart);
            AbstractSpellPart selector0$temp = abstractSpellPart;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractAugment.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    AbstractAugment ignored = (AbstractAugment)selector0$temp;
                    yield 3;
                }
                default -> p.getTypeIndex();
            };
        }).thenComparing(AbstractSpellPart::getLocaleName));
        sorted = sorted.subList(this.glyphsPerPage * page, Math.min(sorted.size(), this.glyphsPerPage * (page + 1)));
        int adjustedXPlaced = 0;
        int totalRowsPlaced = 0;
        int rowOffset = page == 0 ? 2 : 0;
        int yStart = this.bookTop + 2 + (page != 0 || sorted.getFirst() instanceof AbstractCastMethod ? 18 : 0);
        for (AbstractSpellPart part : sorted) {
            if (!foundForms && part instanceof AbstractCastMethod) {
                foundForms = true;
                ++adjustedRowsPlaced;
                this.formTextRow = page != 0 ? 0 : ++totalRowsPlaced;
                adjustedXPlaced = 0;
            } else if (!foundAugments && part instanceof AbstractAugment) {
                foundAugments = true;
                adjustedRowsPlaced += rowOffset;
                this.augmentTextRow = page != 0 ? 0 : (totalRowsPlaced += rowOffset) - 1;
                adjustedXPlaced = 0;
            } else if (!foundEffects && part instanceof AbstractEffect) {
                foundEffects = true;
                adjustedRowsPlaced += rowOffset;
                this.effectTextRow = page != 0 ? 0 : (totalRowsPlaced += rowOffset) - 1;
                adjustedXPlaced = 0;
            } else if (adjustedXPlaced >= 6) {
                ++adjustedRowsPlaced;
                ++totalRowsPlaced;
                adjustedXPlaced = 0;
            }
            if (adjustedRowsPlaced > 6) {
                if (nextPage) break;
                nextPage = true;
                adjustedXPlaced = 0;
                adjustedRowsPlaced = 0;
            }
            int xOffset = 20 * (adjustedXPlaced % 6) + (nextPage ? 134 : 0);
            int yPlace = adjustedRowsPlaced * 18 + yStart + (nextPage && !foundForms ? 18 : 0);
            GlyphButton cell = new GlyphButton(xStart + xOffset, yPlace, part, this::onGlyphClick);
            this.addRenderableWidget((GuiEventListener)cell);
            this.glyphButtons.add(cell);
            ++adjustedXPlaced;
        }
    }

    public void onSearchChanged(String str) {
        if (str.equals(this.previousString)) {
            return;
        }
        this.previousString = str;
        if (!str.isEmpty()) {
            this.searchBar.setSuggestion("");
            this.displayedGlyphs = new ArrayList<AbstractSpellPart>();
            for (AbstractSpellPart spellPart : this.unlockedSpells) {
                if (!spellPart.getLocaleName().toLowerCase().contains(str.toLowerCase())) continue;
                this.displayedGlyphs.add(spellPart);
            }
            for (Renderable w : this.renderables) {
                AbstractSpellPart part;
                if (!(w instanceof GlyphButton)) continue;
                GlyphButton glyphButton = (GlyphButton)w;
                if (glyphButton.abstractSpellPart.getRegistryName() == null || (part = GlyphRegistry.getSpellpartMap().get(glyphButton.abstractSpellPart.getRegistryName())) == null) continue;
                glyphButton.visible = part.getLocaleName().toLowerCase().contains(str.toLowerCase());
            }
        } else {
            this.searchBar.setSuggestion(Component.translatable((String)"ars_nouveau.spell_book_gui.search").getString());
            this.displayedGlyphs = this.unlockedSpells;
            for (Renderable w : this.renderables) {
                if (!(w instanceof GlyphButton)) continue;
                ((GlyphButton)w).visible = true;
            }
        }
        this.updateNextPageButtons();
        this.page = 0;
        this.previousButton.active = false;
        this.previousButton.visible = false;
        this.layoutAllGlyphs(this.page);
        this.validate();
    }

    public void updateNextPageButtons() {
        if (this.displayedGlyphs.size() < this.glyphsPerPage) {
            this.nextButton.visible = false;
            this.nextButton.active = false;
        } else {
            this.nextButton.visible = true;
            this.nextButton.active = true;
        }
    }

    public void onPageIncrease(Button button) {
        if (this.page + 1 >= this.getNumPages()) {
            return;
        }
        ++this.page;
        if (this.displayedGlyphs.size() < this.glyphsPerPage * (this.page + 1)) {
            this.nextButton.visible = false;
            this.nextButton.active = false;
        }
        this.previousButton.active = true;
        this.previousButton.visible = true;
        this.layoutAllGlyphs(this.page);
        this.validate();
    }

    public void onPageDec(Button button) {
        if (this.page <= 0) {
            this.page = 0;
            return;
        }
        --this.page;
        if (this.page == 0) {
            this.previousButton.active = false;
            this.previousButton.visible = false;
        }
        if (this.displayedGlyphs.size() > this.glyphsPerPage * (this.page + 1)) {
            this.nextButton.visible = true;
            this.nextButton.active = true;
        }
        this.layoutAllGlyphs(this.page);
        this.validate();
    }

    public int getExtraGlyphSlots() {
        return ((Boolean)ServerConfig.INFINITE_SPELLS.get() != false ? (Integer)ServerConfig.NOT_SO_INFINITE_SPELLS.get() : 0) + this.bonusSlots;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        boolean isShiftDown = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)Minecraft.getInstance().options.keyShift.getKey().getValue());
        if (this.getExtraGlyphSlots() > 0 && isShiftDown) {
            if (pScrollY < 0.0 && this.nextGlyphButton.active) {
                this.updateWindowOffset(this.spellWindowOffset + 1);
            } else if (pScrollY > 0.0 && this.prevGlyphButton.active) {
                this.updateWindowOffset(this.spellWindowOffset - 1);
            }
            return true;
        }
        SoundManager manager = Minecraft.getInstance().getSoundManager();
        if (pScrollY < 0.0 && this.nextButton.active) {
            this.onPageIncrease((Button)this.nextButton);
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        } else if (pScrollY > 0.0 && this.previousButton.active) {
            this.onPageDec((Button)this.previousButton);
            manager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        }
        return true;
    }

    public void onDocumentationClick(Button button) {
        GuiUtils.openWiki(ArsNouveau.proxy.getPlayer());
    }

    public void onColorClick(Button button) {
        ParticleColor.IntWrapper color = SpellCasterRegistry.from(this.bookStack).getColor(this.selectedSpellSlot).toWrapper();
        Minecraft.getInstance().setScreen((Screen)new GuiColorScreen(color.r, color.g, color.b, this.selectedSpellSlot, this.hand));
    }

    public void onSoundsClick(Button button) {
        ConfiguredSpellSound spellSound = SpellCasterRegistry.from(this.bookStack).getSound(this.selectedSpellSlot);
        Minecraft.getInstance().setScreen((Screen)new SoundScreen(spellSound, this.selectedSpellSlot, this.hand));
    }

    public void onFamiliarClick(Button button) {
        Collection familiarHolders = new ArrayList();
        ANPlayerDataCap cap = CapabilityRegistry.getPlayerDataCap((LivingEntity)ArsNouveau.proxy.getPlayer());
        if (cap != null) {
            familiarHolders = cap.getUnlockedFamiliars().stream().map(s -> s.familiarHolder.getRegistryName()).collect(Collectors.toList());
        }
        ArrayList finalFamiliarHolders = familiarHolders;
        Minecraft.getInstance().setScreen((Screen)new GuiFamiliarScreen(FamiliarRegistry.getFamiliarHolderMap().values().stream().filter(f -> finalFamiliarHolders.contains(f.getRegistryName())).collect(Collectors.toList()), this));
    }

    public void onCraftingSlotClick(Button button) {
        if (button instanceof CraftingButton) {
            CraftingButton craftingButton = (CraftingButton)button;
            craftingButton.clear();
            if (craftingButton.slotNum < this.spell.size()) {
                this.spell.set(((CraftingButton)button).slotNum, null);
            }
        }
        if (this.spell.stream().allMatch(Objects::isNull)) {
            this.spell.clear();
        }
        if (this.nextGlyphButton != null) {
            this.updateNextGlyphArrow();
        }
        this.validate();
    }

    public void onGlyphClick(Button button) {
        GlyphButton button1 = (GlyphButton)button;
        if (!button1.validationErrors.isEmpty()) {
            return;
        }
        for (CraftingButton b : this.craftingCells.subList(this.spellWindowOffset, Math.min(this.spellWindowOffset + 10, this.craftingCells.size()))) {
            if (b.getAbstractSpellPart() != null) continue;
            b.setAbstractSpellPart(button1.abstractSpellPart);
            if (b.slotNum >= this.spell.size()) {
                this.spell.add(button1.abstractSpellPart);
            } else {
                this.spell.set(b.slotNum, button1.abstractSpellPart);
            }
            if (this.nextGlyphButton != null) {
                this.updateNextGlyphArrow();
            }
            this.validate();
            return;
        }
    }

    private void updateNextGlyphArrow() {
        if (this.spellWindowOffset >= this.getExtraGlyphSlots() || this.spellWindowOffset > this.spell.size() - 1) {
            this.nextGlyphButton.active = false;
            this.nextGlyphButton.visible = false;
        } else {
            this.nextGlyphButton.active = true;
            this.nextGlyphButton.visible = true;
        }
    }

    public void onSlotChange(Button button) {
        this.selected_slot.isSelected = false;
        this.selected_slot = (GuiSpellSlot)button;
        this.selected_slot.isSelected = true;
        this.selectedSpellSlot = this.selected_slot.slotNum;
        this.spellname = this.caster.getSpellName(this.selectedSpellSlot);
        this.spell_name.setValue(this.spellname);
        this.spell = new ArrayList<AbstractSpellPart>(this.caster.getSpell(this.selectedSpellSlot).unsafeList());
        this.resetCraftingCells();
        this.updateWindowOffset(0);
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (pCodePoint >= '0' && pCodePoint <= '9') {
            int idx = Integer.parseInt(String.valueOf(pCodePoint));
            if (idx == 0) {
                idx = 10;
            }
            idx = idx - 1 + this.spellWindowOffset;
            Renderable renderable = this.hoveredWidget;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GlyphButton.class, CraftingButton.class}, (Object)renderable, n)) {
                case 0: {
                    GlyphButton button = (GlyphButton)renderable;
                    if (!button.validationErrors.isEmpty()) {
                        return true;
                    }
                    CraftingButton currentCell = this.craftingCells.get(idx);
                    currentCell.setAbstractSpellPart(button.abstractSpellPart);
                    for (int i = this.spell.size(); i <= idx; ++i) {
                        this.spell.add(null);
                    }
                    this.spell.set(idx, button.abstractSpellPart);
                    this.validate();
                    this.setFocused((GuiEventListener)button);
                    return true;
                }
                case 1: {
                    CraftingButton button = (CraftingButton)renderable;
                    for (int i = this.spell.size(); i <= Math.max(button.slotNum, idx); ++i) {
                        this.spell.add(null);
                    }
                    Collections.swap(this.spell, button.slotNum, idx);
                    int left = -1;
                    int right = -1;
                    for (CraftingButton cell : this.craftingCells) {
                        if (cell.slotNum == button.slotNum) {
                            left = cell.slotNum;
                        }
                        if (cell.slotNum == idx) {
                            right = cell.slotNum;
                        }
                        if (left == -1 || right == -1) continue;
                        break;
                    }
                    if (left == -1 || right == -1) {
                        return true;
                    }
                    Collections.swap(this.craftingCells, left, right);
                    this.craftingCells.get((int)left).slotNum = right;
                    this.craftingCells.get((int)right).slotNum = left;
                    this.validate();
                    this.setFocused((GuiEventListener)button);
                    return true;
                }
            }
        }
        if (!super.charTyped(pCodePoint, pModifiers)) {
            if (!(this.searchBar.isFocused() && this.searchBar.active || System.currentTimeMillis() - this.timeOpened <= 30L)) {
                this.clearFocus();
                this.setFocused((GuiEventListener)this.searchBar);
                this.searchBar.active = true;
                this.searchBar.setValue("");
                this.searchBar.onClear.apply("");
                return this.searchBar.charTyped(pCodePoint, pModifiers);
            }
            return false;
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Renderable renderable;
        if (button == 2 && (renderable = this.hoveredWidget) instanceof CraftingButton) {
            CraftingButton cell;
            int i;
            CraftingButton craftingCell = (CraftingButton)renderable;
            int idx = -1;
            int emptySpace = -1;
            for (i = 0; i < this.craftingCells.size(); ++i) {
                cell = this.craftingCells.get(i);
                if (cell.slotNum == craftingCell.slotNum) {
                    while (cell.getAbstractSpellPart() == null && i < this.craftingCells.size()) {
                        cell = this.craftingCells.get(++i);
                    }
                    idx = i;
                    continue;
                }
                if (idx == -1 || cell.getAbstractSpellPart() != null) continue;
                emptySpace = i;
                break;
            }
            if (idx == -1 || emptySpace == -1) {
                return true;
            }
            for (i = this.spell.size(); i <= emptySpace; ++i) {
                this.spell.add(null);
            }
            this.spell.remove(emptySpace);
            for (i = emptySpace; i >= idx + 1; --i) {
                cell = this.craftingCells.get(i);
                CraftingButton prev = this.craftingCells.get(i - 1);
                cell.setAbstractSpellPart(prev.getAbstractSpellPart());
            }
            this.spell.add(idx, null);
            this.craftingCells.get(idx).setAbstractSpellPart(null);
            this.setFocused((GuiEventListener)craftingCell);
            this.validate();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void resetCraftingCells() {
        int i;
        for (CraftingButton button : this.craftingCells) {
            this.removeWidget((GuiEventListener)button);
        }
        this.craftingCells = new ArrayList<CraftingButton>();
        for (i = 0; i < this.numLinks + this.getExtraGlyphSlots(); ++i) {
            CraftingButton cell = new CraftingButton(0, 0, this::onCraftingSlotClick, i);
            this.addRenderableWidget((GuiEventListener)cell);
            this.craftingCells.add(cell);
            cell.visible = false;
            AbstractSpellPart spellPart = i < this.spell.size() ? this.spell.get(i) : null;
            cell.setAbstractSpellPart(spellPart);
        }
        for (i = 0; i < 10; ++i) {
            int offset;
            int placementOffset = i % 10;
            int n = offset = placementOffset >= 5 ? 14 : 0;
            if (i + this.spellWindowOffset >= this.craftingCells.size()) break;
            CraftingButton cell = this.craftingCells.get(this.spellWindowOffset + i);
            cell.setX(this.bookLeft + 19 + 24 * placementOffset + offset);
            cell.setY(this.bookBottom - 43);
            cell.visible = true;
        }
    }

    public void updateWindowOffset(int offset) {
        int extraSlots = this.getExtraGlyphSlots();
        if (!(extraSlots <= 0 || this.spellWindowOffset == 0 && offset > 0 && this.spell.stream().allMatch(Objects::isNull))) {
            this.spellWindowOffset = Mth.clamp((int)offset, (int)0, (int)extraSlots);
            if (this.spellWindowOffset <= 0) {
                this.prevGlyphButton.active = false;
                this.prevGlyphButton.visible = false;
            } else {
                this.prevGlyphButton.active = true;
                this.prevGlyphButton.visible = true;
            }
            this.updateNextGlyphArrow();
        }
        this.validate();
    }

    public void clear(Button button) {
        boolean allWereEmpty = this.spell.isEmpty();
        this.spell.clear();
        if (allWereEmpty) {
            this.spell_name.setValue("");
        }
        this.validate();
    }

    public void onCreateClick(Button button) {
        this.validate();
        if (this.validationErrors.isEmpty()) {
            Spell.Mutable spell = new Spell().mutable();
            for (AbstractSpellPart spellPart : this.spell) {
                if (spellPart == null) continue;
                spell.add(spellPart);
            }
            Networking.sendToServer(new PacketUpdateCaster(spell.immutable(), this.selectedSpellSlot, this.spell_name.getValue(), this.hand == InteractionHand.MAIN_HAND));
        }
    }

    public static void open(InteractionHand hand) {
        Minecraft.getInstance().setScreen((Screen)new GuiSpellBook(hand));
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        int formOffset = 0;
        if (this.formTextRow >= 1) {
            graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.spell_book_gui.form").getString(), this.formTextRow > 6 ? 154 : 20, 5 + 18 * (this.formTextRow + (this.formTextRow == 1 ? 0 : 1)), -8355712, false);
            formOffset = 1;
        }
        if (this.effectTextRow >= 1) {
            graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.spell_book_gui.effect").getString(), this.effectTextRow > 6 ? 154 : 20, 5 + 18 * (this.effectTextRow + formOffset), -8355712, false);
        }
        if (this.augmentTextRow >= 1) {
            graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.spell_book_gui.augment").getString(), this.augmentTextRow > 6 ? 154 : 20, 5 + 18 * (this.augmentTextRow + formOffset), -8355712, false);
        }
        graphics.blit(ArsNouveau.prefix("textures/gui/spell_name_paper.png"), 16, 175, 0.0f, 0.0f, 109, 15, 109, 15);
        graphics.blit(ArsNouveau.prefix("textures/gui/search_paper.png"), 203, -3, 0.0f, 0.0f, 72, 15, 72, 15);
        graphics.blit(ArsNouveau.prefix("textures/gui/clear_paper.png"), 161, 175, 0.0f, 0.0f, 47, 15, 47, 15);
        graphics.blit(ArsNouveau.prefix("textures/gui/create_paper.png"), 216, 175, 0.0f, 0.0f, 56, 15, 56, 15);
        if (this.validationErrors.isEmpty()) {
            graphics.drawString(this.font, (Component)Component.translatable((String)"ars_nouveau.spell_book_gui.create"), 233, 179, -8355712, false);
        } else {
            MutableComponent textComponent = Component.translatable((String)"ars_nouveau.spell_book_gui.create").withStyle(s -> s.withStrikethrough(Boolean.valueOf(true)).withColor((TextColor)TextColor.parseColor((String)"#FFB2B2").getOrThrow()));
            graphics.drawString(this.font, (Component)textComponent, 233, 183, -8355712, false);
        }
        graphics.drawString(this.font, Component.translatable((String)"ars_nouveau.spell_book_gui.clear").getString(), 177, 179, -8355712, false);
        int manaLength = 96;
        manaLength = this.maxManaCache > 0 ? (int)Mth.clamp((float)((float)manaLength * ((float)(this.maxManaCache - this.currentCostCache) / (float)this.maxManaCache)), (float)-1.0f, (float)96.0f) : 0;
        int offsetLeft = 89;
        int yOffset = 210;
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.scale(1.2f, 1.2f, 1.2f);
        poseStack.translate(-25.0f, -30.0f, 0.0f);
        graphics.blit(ArsNouveau.prefix("textures/gui/manabar_gui_border.png"), offsetLeft, yOffset - 18, 0.0f, 0.0f, 108, 18, 256, 256);
        int manaOffset = (int)(((float)ClientInfo.ticksInGame + partialTicks) / 3.0f % 33.0f) * 6;
        if (manaLength >= 0) {
            graphics.blit(ArsNouveau.prefix("textures/gui/manabar_gui_mana.png"), offsetLeft + 9, yOffset - 9, 0.0f, (float)manaOffset, manaLength, 6, 256, 256);
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ArsNouveau.prefix("textures/gui/manabar_gui_grayscale.png"));
            RenderUtils.colorBlit(graphics.pose(), offsetLeft + 8, yOffset - 10, 0, manaOffset, 100, 8, 256, 256, manaLength < 0 ? Color.RED : Color.rainbowColor(ClientInfo.ticksInGame));
        }
        if (ArsNouveauAPI.ENABLE_DEBUG_NUMBERS && this.minecraft != null) {
            String text = this.currentCostCache + "  /  " + this.maxManaCache;
            int maxWidth = this.minecraft.font.width(this.maxManaCache + "  /  " + this.maxManaCache);
            int offset = offsetLeft - maxWidth / 2 + (maxWidth - this.minecraft.font.width(text));
            graphics.drawString(this.minecraft.font, text, offset + 55, yOffset - 10, 0xFFFFFF, false);
        }
        graphics.blit(ArsNouveau.prefix("textures/gui/manabar_gui_border.png"), offsetLeft, yOffset - 17, 0.0f, 18.0f, 108, 20, 256, 256);
        poseStack.popPose();
    }

    private int getCurrentManaCost() {
        Spell spell = new Spell();
        for (AbstractSpellPart part : this.spell) {
            if (part == null) continue;
            spell = spell.add(part);
        }
        int cost = spell.getCost() - ManaUtil.getPlayerDiscounts((LivingEntity)Minecraft.getInstance().player, spell, this.bookStack);
        return Math.max(cost, 0);
    }

    /*
     * WARNING - void declaration
     */
    private void validate() {
        AbstractSpellPart effect;
        this.resetCraftingCells();
        this.currentCostCache = this.getCurrentManaCost();
        this.maxManaCache = ManaUtil.getMaxMana((Player)Minecraft.getInstance().player);
        for (CraftingButton craftingButton : this.craftingCells) {
            craftingButton.validationErrors.clear();
        }
        List<SpellValidationError> errors = this.spellValidator.validate(this.spell);
        for (SpellValidationError ve2 : errors) {
            CraftingButton b = this.craftingCells.get(ve2.getPosition());
            b.validationErrors.add(ve2);
        }
        this.validationErrors = errors;
        for (CraftingButton craftingButton : this.craftingCells) {
            craftingButton.setAugmenting(null);
        }
        Object var2_5 = null;
        for (int i = 0; i < Math.max(this.spell.size(), this.craftingCells.size()); ++i) {
            AbstractSpellPart part;
            AbstractSpellPart abstractSpellPart = part = i < this.spell.size() ? this.spell.get(i) : null;
            if (!(part instanceof AbstractAugment)) {
                AbstractSpellPart abstractSpellPart2 = part;
            }
            for (CraftingButton craftingButton : this.craftingCells) {
                void var2_6;
                if (craftingButton.slotNum != i) continue;
                craftingButton.setAugmenting((AbstractSpellPart)var2_6);
            }
        }
        AbstractSpellPart lastEffect = null;
        int lastGlyphNoGap = 0;
        int i = 0;
        while (i < this.spell.size() && (effect = this.spell.get(i)) != null) {
            if (!(effect instanceof AbstractAugment)) {
                lastEffect = effect;
            }
            lastGlyphNoGap = i++;
        }
        List<AbstractSpellPart> slicedSpell = this.spell.subList(0, this.spell.isEmpty() ? 0 : lastGlyphNoGap + 1);
        for (GlyphButton glyphButton : this.glyphButtons) {
            glyphButton.validationErrors.clear();
            glyphButton.augmentingParent = lastEffect;
            slicedSpell.add(GlyphRegistry.getSpellpartMap().get(glyphButton.abstractSpellPart.getRegistryName()));
            glyphButton.validationErrors.addAll(this.spellValidator.validate(slicedSpell).stream().filter(ve -> ve.getPosition() >= slicedSpell.size() - 1).toList());
            slicedSpell.removeLast();
        }
    }

    @Override
    public void render(GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        super.render(ms, mouseX, mouseY, partialTicks);
        this.hoveredWidget = null;
        for (Renderable widget : this.renderables) {
            AbstractWidget abstractWidget;
            if (!(widget instanceof AbstractWidget) || !GuiUtils.isMouseInRelativeRange(mouseX, mouseY, abstractWidget = (AbstractWidget)widget)) continue;
            this.hoveredWidget = widget;
            break;
        }
        this.spell_name.setSuggestion(this.spell_name.getValue().isEmpty() ? Component.translatable((String)"ars_nouveau.spell_book_gui.spell_name").getString() : "");
    }

    @Override
    public void collectTooltips(GuiGraphics stack, int mouseX, int mouseY, List<Component> tooltip) {
        if (GuiUtils.isMouseInRelativeRange(mouseX, mouseY, (AbstractWidget)this.createSpellButton)) {
            if (!this.validationErrors.isEmpty()) {
                boolean foundGlyphErrors = false;
                tooltip.add((Component)Component.translatable((String)"ars_nouveau.spell.validation.crafting.invalid").withStyle(ChatFormatting.RED));
                for (SpellValidationError error : this.validationErrors) {
                    if (error.getPosition() < 0) {
                        tooltip.add((Component)error.makeTextComponentExisting());
                        continue;
                    }
                    foundGlyphErrors = true;
                }
                if (foundGlyphErrors) {
                    tooltip.add((Component)Component.translatable((String)"ars_nouveau.spell.validation.crafting.invalid_glyphs"));
                }
            }
        } else {
            super.collectTooltips(stack, mouseX, mouseY, tooltip);
        }
    }

    @Override
    public void drawTooltip(GuiGraphics stack, int mouseX, int mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        this.collectTooltips(stack, mouseX, mouseY, tooltip);
        if (!tooltip.isEmpty()) {
            stack.renderTooltip(this.font, tooltip, Optional.ofNullable(this.collectComponent(mouseX, mouseY)), mouseX, mouseY);
        }
    }

    protected TooltipComponent collectComponent(int mouseX, int mouseY) {
        for (Renderable renderable : this.renderables) {
            GlyphButton widget;
            if (!(renderable instanceof GlyphButton) || !GuiUtils.isMouseInRelativeRange(mouseX, mouseY, (AbstractWidget)(widget = (GlyphButton)renderable))) continue;
            return widget.abstractSpellPart.spellSchools.isEmpty() ? null : new SchoolTooltip(widget.abstractSpellPart);
        }
        return null;
    }
}

