/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.entry.DocEntry;
import com.hollingsworth.arsnouveau.api.documentation.search.Search;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.documentation.PageHolderScreen;
import com.hollingsworth.arsnouveau.client.registry.ModKeyBindings;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.items.WornNotebook;
import com.hollingsworth.nuggets.client.rendering.RenderHelpers;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class DocItemTooltipHandler {
    private static float lexiconLookupTime = 0.0f;

    public static void onTooltip(GuiGraphics graphics, ItemStack stack, int mouseX, int mouseY) {
        boolean boundToControl;
        Screen stackAt;
        PoseStack ms = graphics.pose();
        Minecraft mc = Minecraft.getInstance();
        int tooltipX = mouseX;
        int tooltipY = mouseY - 4;
        if (mc.player == null) {
            return;
        }
        DocEntry docEntry = Search.itemToEntryMap.get(stack.getItem());
        if (docEntry == null) {
            return;
        }
        boolean hasSpellBook = false;
        for (int i = 0; i < Inventory.getSelectionSize(); ++i) {
            stackAt = mc.player.getInventory().getItem(i);
            if (stackAt.isEmpty() || !(stackAt.getItem() instanceof SpellBook) && !(stackAt.getItem() instanceof WornNotebook)) continue;
            hasSpellBook = true;
        }
        if (!hasSpellBook) {
            lexiconLookupTime = 0.0f;
            return;
        }
        stackAt = mc.screen;
        if (stackAt instanceof PageHolderScreen) {
            PageHolderScreen pageHolderScreen = (PageHolderScreen)stackAt;
            if (pageHolderScreen.entry == docEntry) {
                return;
            }
        }
        int x = tooltipX - 34;
        RenderSystem.disableDepthTest();
        graphics.fill(x - 4, tooltipY - 4, x + 20, tooltipY + 26, 0x44000000);
        graphics.fill(x - 6, tooltipY - 6, x + 22, tooltipY + 28, 0x44000000);
        boolean bl = boundToControl = ModKeyBindings.OPEN_DOCUMENTATION.getKey().getValue() == 341;
        if (boundToControl ? PageHolderScreen.hasControlDown() : InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)ModKeyBindings.OPEN_DOCUMENTATION.getKey().getValue())) {
            int cx = x + 8;
            int cy = tooltipY + 8;
            float r = 12.0f;
            float time = 20.0f;
            float angles = (lexiconLookupTime += ClientInfo.deltaTicks) / time * 360.0f;
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            BufferBuilder buf = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            float a = 0.5f + 0.2f * ((float)Math.cos(ClientInfo.totalTicks / 10.0f) * 0.5f + 0.5f);
            buf.addVertex((float)cx, (float)cy, 0.0f).setColor(0.0f, 0.5f, 0.0f, a);
            for (float i = angles; i > 0.0f; i -= 1.0f) {
                double rad = (double)((i - 90.0f) / 180.0f) * Math.PI;
                buf.addVertex((float)((double)cx + Math.cos(rad) * (double)r), (float)((double)cy + Math.sin(rad) * (double)r), 0.0f).setColor(0.0f, 1.0f, 0.0f, 1.0f);
            }
            buf.addVertex((float)cx, (float)cy, 0.0f).setColor(0.0f, 1.0f, 0.0f, 0.0f);
            BufferUploader.drawWithShader((MeshData)buf.build());
            RenderSystem.disableBlend();
            if (lexiconLookupTime >= time) {
                DocClientUtils.openToEntry(docEntry.id(), 0);
                lexiconLookupTime = 0.0f;
            }
        } else {
            lexiconLookupTime = 0.0f;
        }
        ms.pushPose();
        ms.translate(0.0f, 0.0f, 300.0f);
        RenderHelpers.drawItemAsIcon((ItemStack)docEntry.renderStack(), (GuiGraphics)graphics, (int)x, (int)tooltipY, (int)16, (boolean)false);
        ms.popPose();
        ms.pushPose();
        ms.translate(0.0f, 0.0f, 500.0f);
        graphics.drawString(mc.font, "?", x + 10, tooltipY + 8, -1);
        ms.scale(0.5f, 0.5f, 1.0f);
        boolean mac = Minecraft.ON_OSX;
        MutableComponent key = (boundToControl ? (mac ? Component.literal((String)"Cmd") : Component.literal((String)"Ctrl")) : ModKeyBindings.OPEN_DOCUMENTATION.getTranslatedKeyMessage().copy()).withStyle(ChatFormatting.BOLD);
        graphics.drawString(mc.font, (Component)key, (x + 10) * 2 - 16, (tooltipY + 8) * 2 + 20, -1);
        ms.popPose();
        RenderSystem.enableDepthTest();
    }
}

