/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.emi;

import com.hollingsworth.arsnouveau.client.container.CraftingTerminalMenu;
import com.hollingsworth.arsnouveau.client.container.StoredItemStack;
import com.hollingsworth.arsnouveau.common.network.ClientTransferHandlerPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class EmiLecternRecipeHandler<T extends CraftingTerminalMenu>
implements StandardRecipeHandler<T> {
    public List<Slot> getInputSources(T handler) {
        List<StoredItemStack> storedItems = ((CraftingTerminalMenu)handler).getStoredItems();
        NonNullList playerInventory = ((CraftingTerminalMenu)handler).slots;
        ArrayList<Slot> fakeSlots = new ArrayList<Slot>(storedItems.size() + playerInventory.size());
        SimpleContainer container = new SimpleContainer(storedItems.size() + playerInventory.size());
        int idx = 0;
        for (StoredItemStack storedItem : storedItems) {
            container.setItem(idx, storedItem.getActualStack());
            fakeSlots.add(new Slot((Container)container, idx, idx, 0));
            ++idx;
        }
        for (Slot slot : playerInventory) {
            if (slot instanceof CraftingTerminalMenu.SlotCrafting || slot instanceof CraftingTerminalMenu.ActiveResultSlot) continue;
            container.setItem(idx, slot.getItem());
            fakeSlots.add(new Slot((Container)container, idx, idx, 0));
            ++idx;
        }
        return fakeSlots;
    }

    public List<Slot> getCraftingSlots(T handler) {
        ArrayList<Slot> craftingSlots = new ArrayList<Slot>(9);
        for (Slot slot : ((CraftingTerminalMenu)handler).slots) {
            if (!(slot instanceof CraftingTerminalMenu.SlotCrafting)) continue;
            craftingSlots.add(slot);
            if (craftingSlots.size() < 9) continue;
            break;
        }
        return craftingSlots;
    }

    @Nullable
    public Slot getOutputSlot(T handler) {
        for (Slot slot : ((CraftingTerminalMenu)handler).slots) {
            if (!(slot instanceof CraftingTerminalMenu.ActiveResultSlot)) continue;
            return slot;
        }
        return null;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING;
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        CraftingTerminalMenu handler = (CraftingTerminalMenu)context.getScreenHandler();
        if (handler == null) {
            return false;
        }
        ArrayList<EmiIngredient> missing = new ArrayList<EmiIngredient>();
        List requiredItems = recipe.getInputs();
        List<Slot> sources = this.getInputSources(handler);
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
        for (EmiIngredient required : requiredItems) {
            ArrayList<ItemStack> possibleStacks = new ArrayList<ItemStack>();
            for (EmiStack possible : required.getEmiStacks()) {
                possibleStacks.add(possible.getItemStack());
            }
            if (possibleStacks.isEmpty()) {
                inputs.add(List.of());
                continue;
            }
            inputs.add(possibleStacks);
            boolean found = false;
            for (ItemStack stack : possibleStacks) {
                if (stack == null || !sources.stream().anyMatch(slot -> ItemStack.isSameItemSameComponents((ItemStack)slot.getItem(), (ItemStack)stack))) continue;
                found = true;
                break;
            }
            if (found) continue;
            missing.add(required);
        }
        Networking.sendToServer(new ClientTransferHandlerPacket(inputs));
        return missing.isEmpty();
    }
}

