/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.documentation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hollingsworth.arsnouveau.api.documentation.DocPlayerData;
import com.hollingsworth.arsnouveau.api.registry.DocumentationRegistry;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class DocDataLoader {
    public static final String DATA_FOLDER = "./config/ars_nouveau/";
    public static final Path DOC_DATA_PATH = Path.of("./config/ars_nouveau/doc_data.json", new String[0]);

    public static void writeBookmarks() {
        List<ResourceLocation> bookmarks = DocPlayerData.bookmarks;
        try {
            Files.createDirectories(Path.of(DATA_FOLDER, new String[0]), new FileAttribute[0]);
            JsonObject element = new JsonObject();
            element.addProperty("version", (Number)1);
            JsonArray bookmarksArray = new JsonArray();
            bookmarks.forEach(e -> bookmarksArray.add(e.toString()));
            element.add("bookmarks", (JsonElement)bookmarksArray);
            if (!Files.exists(DOC_DATA_PATH, new LinkOption[0])) {
                Files.createFile(DOC_DATA_PATH, new FileAttribute[0]);
            }
            Files.writeString(DOC_DATA_PATH, (CharSequence)element.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static List<ResourceLocation> loadBookmarks() {
        ArrayList<ResourceLocation> bookmarks = new ArrayList<ResourceLocation>();
        try {
            Files.createDirectories(Path.of(DATA_FOLDER, new String[0]), new FileAttribute[0]);
            String content = Files.readString(Path.of("./config/ars_nouveau/doc_data.json", new String[0]), StandardCharsets.UTF_8);
            JsonObject element = JsonParser.parseString((String)content).getAsJsonObject();
            if (element.has("bookmarks")) {
                element.getAsJsonArray("bookmarks").forEach(e -> bookmarks.add(ResourceLocation.tryParse((String)e.getAsString())));
                ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
                for (ResourceLocation loc : bookmarks) {
                    if (loc != null && DocumentationRegistry.getEntry(loc) != null) continue;
                    toRemove.add(loc);
                }
                bookmarks.removeAll(toRemove);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return bookmarks;
    }
}

