/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.container;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.container.AbstractStorageTerminalScreen;
import com.hollingsworth.arsnouveau.client.container.CraftingTerminalMenu;
import com.hollingsworth.arsnouveau.client.container.IAutoFillTerminal;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.setup.config.Config;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.recipebook.GhostRecipe;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CraftingTerminalScreen
extends AbstractStorageTerminalScreen<CraftingTerminalMenu>
implements RecipeUpdateListener {
    private static final ResourceLocation gui = ArsNouveau.prefix("textures/gui/crafting_terminal.png");
    private static final ResourceLocation gui_expanded = ArsNouveau.prefix("textures/gui/crafting_terminal_expanded.png");
    private final RecipeBookComponent recipeBookGui = new RecipeBookComponent();
    private boolean widthTooNarrow;
    private static final ResourceLocation RECIPE_BUTTON_TEXTURE = ArsNouveau.prefix("textures/gui/recipe_book.png");
    private static final ResourceLocation CLEAR_CRAFT_TEXTURE = ArsNouveau.prefix("textures/gui/craft_clear.png");
    private static final ResourceLocation EXPAND_TEXTURE = ArsNouveau.prefix("textures/gui/expand_inventory.png");
    private static final ResourceLocation COLLAPSE_TEXTURE = ArsNouveau.prefix("textures/gui/collapse_inventory.png");
    private EditBox recipeBookSearch;
    private GhostRecipe ghostRecipe;
    public GuiImageButton btnClr;
    public GuiImageButton btnRecipeBook;
    public GuiImageButton btnExpand;
    public GuiImageButton btnCollapse;

    public CraftingTerminalScreen(CraftingTerminalMenu screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        try {
            this.recipeBookGui.stackedContents = (CraftingTerminalMenu)this.getMenu().new CraftingTerminalMenu.TerminalRecipeItemHelper();
            this.ghostRecipe = this.recipeBookGui.ghostRecipe;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ResourceLocation getGui() {
        return this.expanded ? gui_expanded : gui;
    }

    @Override
    protected void onUpdateSearch(String text) {
        if (IAutoFillTerminal.hasSync() || this.searchType == 1) {
            if (this.recipeBookSearch != null) {
                this.recipeBookSearch.setValue(text);
            }
            this.recipeBookGui.recipesUpdated();
        }
    }

    @Override
    protected void init() {
        this.imageWidth = 202;
        this.imageHeight = 248;
        this.rowCount = 3;
        super.init();
        this.widthTooNarrow = this.width < 379;
        this.recipeBookGui.init(this.width, this.height + 30, this.minecraft, this.widthTooNarrow, (RecipeBookMenu)this.menu);
        this.leftPos = this.recipeBookGui.updateScreenPosition(this.width, this.imageWidth);
        this.addRenderableWidget((GuiEventListener)this.recipeBookGui);
        this.setInitialFocus((GuiEventListener)this.recipeBookGui);
        int recipeButtonY = this.height / 2 - 34;
        int collapseButtonY = this.height / 2 + 23;
        this.btnClr = new GuiImageButton(this.leftPos + 86, recipeButtonY, 0, 0, 9, 9, 9, 9, CLEAR_CRAFT_TEXTURE, b -> this.clearGrid());
        this.btnExpand = new GuiImageButton(this.leftPos + 86, recipeButtonY - 12, 0, 0, 14, 3, 14, 3, EXPAND_TEXTURE, b -> this.expandScreen());
        this.btnCollapse = new GuiImageButton(this.leftPos + 86, collapseButtonY, 0, 0, 14, 3, 14, 3, COLLAPSE_TEXTURE, b -> this.collapseScreen());
        this.addRenderableWidget((GuiEventListener)this.btnClr);
        this.addRenderableWidget((GuiEventListener)this.btnCollapse);
        this.addRenderableWidget((GuiEventListener)this.btnExpand);
        this.btnRecipeBook = (GuiImageButton)this.addRenderableWidget((GuiEventListener)new GuiImageButton(this.leftPos + 98, recipeButtonY, 0, 0, 9, 9, 9, 9, RECIPE_BUTTON_TEXTURE, thisButton -> {
            this.recipeBookGui.initVisuals();
            this.recipeBookSearch = this.recipeBookGui.searchBox;
            this.recipeBookGui.toggleVisibility();
            this.leftPos = this.recipeBookGui.updateScreenPosition(this.width, this.imageWidth);
            ((GuiImageButton)thisButton).setPosition(this.leftPos + 98, recipeButtonY);
            this.searchField.setX(this.leftPos + 115);
            this.btnClr.setX(this.leftPos + 86);
            this.buttonSortingType.setX(this.leftPos - 18);
            this.buttonDirection.setX(this.leftPos - 18);
            this.buttonSearchType.setX(this.leftPos - 18);
            this.btnCollapse.setX(this.leftPos + 86);
            this.btnExpand.setX(this.leftPos + 86);
        }));
        if (this.recipeBookGui.isVisible()) {
            this.buttonSortingType.setX(this.leftPos - 18);
            this.buttonDirection.setX(this.leftPos - 18);
            this.buttonSearchType.setX(this.leftPos - 18);
            this.searchField.setX(this.leftPos + 115);
            this.recipeBookSearch = this.recipeBookGui.searchBox;
            this.btnCollapse.setX(this.leftPos + 86);
            this.btnExpand.setX(this.leftPos + 86);
        }
        this.btnRecipeBook.visible = (Boolean)Config.SHOW_RECIPE_BOOK.get();
        this.onExpandedChanged(this.expanded);
        this.onPacket();
    }

    @Override
    protected void onExpandedChanged(boolean expanded) {
        this.expanded = expanded;
        super.onExpandedChanged(expanded);
        this.btnCollapse.visible = this.expanded;
        this.btnExpand.visible = !this.expanded;
        this.btnClr.visible = !this.expanded;
        this.btnRecipeBook.visible = !this.expanded && (Boolean)Config.SHOW_RECIPE_BOOK.get() != false;
    }

    public void collapseScreen() {
        this.rowCount = 3;
        this.expanded = false;
        this.onExpandedChanged(false);
        this.syncSortSettings();
    }

    public void expandScreen() {
        this.rowCount = 7;
        this.expanded = true;
        if (this.recipeBookGui.isVisible()) {
            this.btnRecipeBook.onPress();
        }
        this.onExpandedChanged(true);
        this.syncSortSettings();
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.recipeBookGui.tick();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        if (this.recipeBookGui.isVisible() && this.widthTooNarrow) {
            this.renderBg(graphics, partialTicks, mouseX, mouseY);
            this.recipeBookGui.render(graphics, mouseX, mouseY, partialTicks);
        } else {
            this.recipeBookGui.render(graphics, mouseX, mouseY, partialTicks);
            super.render(graphics, mouseX, mouseY, partialTicks);
            this.recipeBookGui.renderGhostRecipe(graphics, this.leftPos, this.topPos, true, partialTicks);
        }
        this.renderTooltip(graphics, mouseX, mouseY);
        this.recipeBookGui.renderTooltip(graphics, this.leftPos, this.topPos, mouseX, mouseY);
        this.setInitialFocus((GuiEventListener)this.recipeBookGui);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return (!this.widthTooNarrow || !this.recipeBookGui.isVisible()) && super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.recipeBookGui.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_)) {
            return true;
        }
        return this.widthTooNarrow && this.recipeBookGui.isVisible() || super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean flag = mouseX < (double)guiLeftIn || mouseY < (double)guiTopIn || mouseX >= (double)(guiLeftIn + this.imageWidth) || mouseY >= (double)(guiTopIn + this.imageHeight);
        return this.recipeBookGui.hasClickedOutside(mouseX, mouseY, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, mouseButton) && flag;
    }

    protected void slotClicked(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        super.slotClicked(slotIn, slotId, mouseButton, type);
        this.recipeBookGui.slotClicked(slotIn);
    }

    public void recipesUpdated() {
        this.recipeBookGui.recipesUpdated();
    }

    public RecipeBookComponent getRecipeBookComponent() {
        return this.recipeBookGui;
    }

    private void clearGrid() {
        this.minecraft.gameMode.handleInventoryButtonClick(((CraftingTerminalMenu)this.menu).containerId, 0);
    }

    @Override
    public boolean keyPressed(int code, int p_231046_2_, int p_231046_3_) {
        if (code == 83 && this.hoveredSlot != null) {
            ItemStack itemstack = null;
            for (int i = 0; i < this.ghostRecipe.size(); ++i) {
                GhostRecipe.GhostIngredient ghostrecipe$ghostingredient = this.ghostRecipe.get(i);
                int j = ghostrecipe$ghostingredient.getX();
                int k = ghostrecipe$ghostingredient.getY();
                if (j != this.hoveredSlot.x || k != this.hoveredSlot.y) continue;
                itemstack = ghostrecipe$ghostingredient.getItem();
            }
            if (itemstack != null) {
                this.searchField.setValue(itemstack.getHoverName().getString());
                this.searchField.setFocused(false);
                return true;
            }
        }
        return super.keyPressed(code, p_231046_2_, p_231046_3_);
    }
}

