/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.util;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DamageUtil {
    public static DamageSource source(LevelAccessor level, ResourceKey<DamageType> key) {
        Registry registry = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        return new DamageSource((Holder)registry.getHolderOrThrow(key));
    }

    public static DamageSource source(LevelAccessor level, ResourceKey<DamageType> key, @Nullable Entity entity) {
        return DamageUtil.source(level, key, entity, null);
    }

    public static DamageSource source(LevelAccessor level, ResourceKey<DamageType> key, @Nullable Entity entity, @Nullable Entity direct) {
        Holder.Reference type = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(key);
        if (entity != null && direct != null) {
            return new SpellDamageSource((Holder<DamageType>)type, entity, direct);
        }
        if (entity != null) {
            return new SpellDamageSource((Holder<DamageType>)type, entity);
        }
        return new SpellDamageSource((Holder<DamageType>)type);
    }

    public static class SpellDamageSource
    extends DamageSource {
        public int luckLevel = 0;

        public int getLuckLevel() {
            return this.luckLevel;
        }

        public void setLuckLevel(int luckLevel) {
            this.luckLevel = luckLevel;
        }

        public SpellDamageSource(Holder<DamageType> pType, @Nullable Entity pDirectEntity, @Nullable Entity pCausingEntity, @Nullable Vec3 pDamageSourcePosition) {
            super(pType, pDirectEntity, pCausingEntity, pDamageSourcePosition);
        }

        public SpellDamageSource(Holder<DamageType> pType, @Nullable Entity pDirectEntity, @Nullable Entity pCausingEntity) {
            this(pType, pDirectEntity, pCausingEntity, null);
        }

        public SpellDamageSource(Holder<DamageType> pType, Vec3 pDamageSourcePosition) {
            this(pType, null, null, pDamageSourcePosition);
        }

        public SpellDamageSource(Holder<DamageType> pType, @Nullable Entity pEntity) {
            this(pType, pEntity, pEntity);
        }

        public SpellDamageSource(Holder<DamageType> pType) {
            this(pType, null, null, null);
        }
    }
}

