/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau;

import com.hollingsworth.arsnouveau.api.registry.BuddingConversionRegistry;
import com.hollingsworth.arsnouveau.api.registry.CasterTomeRegistry;
import com.hollingsworth.arsnouveau.api.registry.GenericRecipeRegistry;
import com.hollingsworth.arsnouveau.api.registry.ScryRitualRegistry;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.registry.ClientHandler;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.entity.BubbleEntity;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.ClientEventHandler;
import com.hollingsworth.arsnouveau.common.entity.pathfinding.FMLEventHandler;
import com.hollingsworth.arsnouveau.common.event.BreezeEvent;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.util.Log;
import com.hollingsworth.arsnouveau.common.world.Terrablender;
import com.hollingsworth.arsnouveau.setup.ModSetup;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.config.StartupConfig;
import com.hollingsworth.arsnouveau.setup.proxy.ClientProxy;
import com.hollingsworth.arsnouveau.setup.proxy.IProxy;
import com.hollingsworth.arsnouveau.setup.proxy.ServerProxy;
import com.hollingsworth.arsnouveau.setup.registry.APIRegistry;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DispenserBehaviorRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import com.hollingsworth.arsnouveau.setup.reward.Rewards;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.world.chunk.TicketController;

@Mod(value="ars_nouveau")
public class ArsNouveau {
    public static final String MODID = "ars_nouveau";
    public static IProxy proxy;
    public static boolean caelusLoaded;
    public static boolean terrablenderLoaded;
    public static boolean optifineLoaded;
    public static boolean sodiumLoaded;
    public static boolean immersivePortalsLoaded;
    public static boolean patchouliLoaded;
    public static List<String> postLoadWarnings;
    public static TicketController ticketController;
    public static boolean isDebug;

    public ArsNouveau(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.addListener(FMLEventHandler::onServerStopped);
        caelusLoaded = ModList.get().isLoaded("caelus");
        terrablenderLoaded = ModList.get().isLoaded("terrablender");
        sodiumLoaded = ModList.get().isLoaded("rubidium");
        patchouliLoaded = ModList.get().isLoaded("patchouli");
        immersivePortalsLoaded = ModList.get().isLoaded("immersive_portals_core");
        APIRegistry.setup();
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)StartupConfig.STARTUP_CONFIG);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SERVER_CONFIG);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_CONFIG);
        if (FMLEnvironment.dist.isClient()) {
            NeoForge.EVENT_BUS.register(ClientEventHandler.class);
        }
        modEventBus.addListener(Networking::register);
        modEventBus.addListener(ModSetup::registerEvents);
        modEventBus.addListener(CapabilityRegistry::registerCapabilities);
        ModSetup.registers(modEventBus);
        modEventBus.addListener(ModEntities::registerPlacements);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::postModLoadEvent);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(e -> e.register(ticketController));
        NeoForge.EVENT_BUS.addListener(BubbleEntity::onAttacked);
        NeoForge.EVENT_BUS.addListener(BubbleEntity::entityHurt);
        NeoForge.EVENT_BUS.addListener(BreezeEvent::onSpellResolve);
        NeoForge.EVENT_BUS.addListener(e -> ClientInfo.endClientTick());
        NeoForge.EVENT_BUS.addListener(e -> ClientInfo.renderTickStart(e.getPartialTick().getGameTimeDeltaPartialTick(false)));
        NeoForge.EVENT_BUS.addListener(e -> ClientInfo.renderTickEnd());
        ANCriteriaTriggers.init();
        try {
            Thread thread = new Thread(Rewards::init);
            thread.setDaemon(true);
            thread.start();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        proxy = FMLEnvironment.dist.isClient() ? new Supplier<IProxy>(this){

            @Override
            public IProxy get() {
                return new ClientProxy();
            }
        }.get() : new ServerProxy();
    }

    public void setup(FMLCommonSetupEvent event) {
        APIRegistry.postInit();
        if (terrablenderLoaded && (Integer)Config.ARCHWOOD_FOREST_WEIGHT.get() > 0) {
            event.enqueueWork(Terrablender::registerBiomes);
        }
        NeoForge.EVENT_BUS.addListener(e -> {
            GenericRecipeRegistry.reloadAll(e.getServer().getRecipeManager());
            CasterTomeRegistry.reloadTomeData(e.getServer().getRecipeManager(), (RegistryAccess)e.getServer().registryAccess());
            BuddingConversionRegistry.reloadBuddingConversionRecipes(e.getServer().getRecipeManager());
            ScryRitualRegistry.reloadScryRitualRecipes(e.getServer().getRecipeManager());
        });
    }

    public void postModLoadEvent(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.BLAZING_SAPLING.asItem(), 0.3f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.CASCADING_SAPLING.asItem(), 0.3f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.FLOURISHING_SAPLING.asItem(), 0.5f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.VEXING_SAPLING.asItem(), 0.3f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.SOURCEBERRY_BUSH.asItem(), 0.3f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)((ItemLike)ItemsRegistry.MAGE_BLOOM.get()), 0.65f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.MAGE_BLOOM_CROP.asItem(), 0.65f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.BOMBEGRANTE_POD.asItem(), 0.65f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.MENDOSTEEN_POD.asItem(), 0.65f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.FROSTAYA_POD.asItem(), 0.65f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.BASTION_POD.asItem(), 0.65f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.FLOURISHING_LEAVES.asItem(), 0.3f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.VEXING_LEAVES.asItem(), 0.3f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.CASCADING_LEAVE.asItem(), 0.3f);
            ComposterBlock.COMPOSTABLES.putIfAbsent((Object)BlockRegistry.BLAZING_LEAVES.asItem(), 0.3f);
            FlowerPotBlock flowerPot = (FlowerPotBlock)Blocks.FLOWER_POT;
            for (Map.Entry<Supplier<ResourceLocation>, FlowerPotBlock> pot : BlockRegistry.flowerPots.entrySet()) {
                flowerPot.addPlant(pot.getKey().get(), pot::getValue);
            }
            DispenserBehaviorRegistry.register();
        });
        for (String warning : postLoadWarnings) {
            Log.getLogger().error(warning);
        }
    }

    public void clientSetup(FMLClientSetupEvent event) {
        ModLoadingContext.get().getActiveContainer().getEventBus().addListener(ClientHandler::init);
        try {
            Class.forName("net.optifine.Config");
            optifineLoaded = true;
        }
        catch (Exception e) {
            optifineLoaded = false;
        }
    }

    public static ResourceLocation prefix(String str) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)str);
    }

    static {
        caelusLoaded = false;
        terrablenderLoaded = false;
        optifineLoaded = false;
        sodiumLoaded = false;
        immersivePortalsLoaded = false;
        patchouliLoaded = false;
        postLoadWarnings = new ArrayList<String>();
        ticketController = new TicketController(ArsNouveau.prefix("ticket_controller"), (level, ticketHelper) -> ticketHelper.getEntityTickets().forEach((uuid, chunk) -> {
            if (level.getEntity(uuid) == null) {
                ticketHelper.removeAllTickets(uuid);
            }
        }));
        isDebug = false;
    }
}

