/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.setup.registry;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.block.tile.CraftingLecternTile;
import com.hollingsworth.arsnouveau.common.block.tile.ScribesTile;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.setup.registry.BlockEntityTypeRegistryWrapper;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class CapabilityRegistry {
    public static final EntityCapability<ManaCap, Void> MANA_CAPABILITY = EntityCapability.createVoid((ResourceLocation)ArsNouveau.prefix("mana"), ManaCap.class);
    public static final EntityCapability<ANPlayerDataCap, Void> PLAYER_DATA_CAP = EntityCapability.createVoid((ResourceLocation)ArsNouveau.prefix("player_data"), ANPlayerDataCap.class);
    public static final BlockCapability<IItemHandler, Direction> LECTERN_CAP = BlockCapability.create((ResourceLocation)ArsNouveau.prefix("lectern_handler"), IItemHandler.class, Direction.class);

    public static ManaCap getMana(LivingEntity entity) {
        if (entity == null) {
            return null;
        }
        return (ManaCap)entity.getCapability(MANA_CAPABILITY);
    }

    public static ANPlayerDataCap getPlayerDataCap(LivingEntity entity) {
        if (entity == null) {
            return null;
        }
        return (ANPlayerDataCap)entity.getCapability(PLAYER_DATA_CAP);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(MANA_CAPABILITY, EntityType.PLAYER, (player, ctx) -> new ManaCap((LivingEntity)player));
        event.registerEntity(PLAYER_DATA_CAP, EntityType.PLAYER, (player, ctx) -> new ANPlayerDataCap((LivingEntity)player));
        List<BlockEntityTypeRegistryWrapper<ScribesTile>> containers = List.of(BlockRegistry.ENCHANTING_APP_TILE, BlockRegistry.IMBUEMENT_TILE, BlockRegistry.SCRIBES_TABLE_TILE);
        for (BlockEntityTypeRegistryWrapper<ScribesTile> container : containers) {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)container.get(), (c, side) -> new InvWrapper((Container)c));
        }
        event.registerBlockEntity(LECTERN_CAP, (BlockEntityType)BlockRegistry.CRAFTING_LECTERN_TILE.get(), (c, side) -> c.getCapability((CraftingLecternTile)c, (Direction)side));
    }

    @EventBusSubscriber(modid="ars_nouveau")
    public static class EventHandler {
        @SubscribeEvent
        public static void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
            if (event.getEntity() instanceof ServerPlayer) {
                EventHandler.syncPlayerCap(event.getEntity());
            }
        }

        @SubscribeEvent
        public static void respawnEvent(PlayerEvent.PlayerRespawnEvent event) {
            if (event.getEntity() instanceof ServerPlayer) {
                EventHandler.syncPlayerCap(event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerStartTrackingEvent(PlayerEvent.StartTracking event) {
            if (event.getTarget() instanceof Player && event.getEntity() instanceof ServerPlayer) {
                EventHandler.syncPlayerCap(event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerDimChangedEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (event.getEntity() instanceof ServerPlayer) {
                EventHandler.syncPlayerCap(event.getEntity());
            }
        }

        public static void syncPlayerCap(Player player) {
            ServerPlayer serverPlayer;
            ANPlayerDataCap playerData;
            if (player instanceof ServerPlayer && (playerData = CapabilityRegistry.getPlayerDataCap((LivingEntity)(serverPlayer = (ServerPlayer)player))) != null) {
                playerData.syncToClient(serverPlayer);
            }
        }
    }
}

