/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.item.inv.ExtractedStack;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.util.ItemUtil;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class EffectToss
extends AbstractEffect {
    public static EffectToss INSTANCE = new EffectToss();

    public EffectToss() {
        super(GlyphLib.EffectTossID, "Toss");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos pos = rayTraceResult.getEntity().blockPosition();
        this.summonStack(shooter, spellContext, world, pos, new InventoryManager(spellContext.getCaster()));
    }

    public void summonStack(LivingEntity shooter, SpellContext context, Level world, BlockPos pos, InventoryManager inventoryManager) {
        ExtractedStack casterStack = inventoryManager.extractItem(i -> {
            if (!i.isEmpty() && context.getCaster() instanceof TileCaster) {
                return true;
            }
            if (!i.isEmpty() && shooter instanceof Player) {
                return !ItemStack.matches((ItemStack)shooter.getMainHandItem(), (ItemStack)i);
            }
            return false;
        }, 64);
        world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, casterStack.stack.copy()));
        casterStack.stack.setCount(0);
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos pos = rayTraceResult.getBlockPos().relative(rayTraceResult.getDirection());
        InventoryManager manager = new InventoryManager(spellContext.getCaster());
        if (world.getBlockEntity(rayTraceResult.getBlockPos()) == null) {
            this.summonStack(shooter, spellContext, world, pos, manager);
            return;
        }
        IItemHandler targetInv = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, rayTraceResult.getBlockPos(), null);
        if (targetInv == null) {
            return;
        }
        ExtractedStack casterStack = manager.extractByAmount(stackToExtract -> {
            if (stackToExtract.isEmpty()) {
                return 0;
            }
            if (shooter instanceof Player && ItemStack.matches((ItemStack)shooter.getMainHandItem(), (ItemStack)stackToExtract)) {
                return 0;
            }
            for (int i = 0; i < targetInv.getSlots(); ++i) {
                ItemStack simReturn;
                int origSize;
                int maxRoom;
                int adjustedMax;
                ItemStack stackInTarget = targetInv.getStackInSlot(i);
                if (stackInTarget.isEmpty()) {
                    return targetInv.getSlotLimit(i);
                }
                if (!ItemUtil.canStack(stackInTarget, stackToExtract) || (adjustedMax = Math.min(maxRoom = (origSize = stackToExtract.getCount()) - (simReturn = targetInv.insertItem(i, stackToExtract, true)).getCount(), targetInv.getSlotLimit(i))) <= 0) continue;
                return adjustedMax;
            }
            return 0;
        });
        casterStack.stack = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)casterStack.getStack(), (boolean)false);
        casterStack.returnOrDrop(world, pos);
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    @Override
    public String getBookDescription() {
        return "Causes the caster to place an item from their inventory to a location. If this glyph is used on an inventory, the item will attempt to be inserted into it.";
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }
}

