/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EffectSmelt
extends AbstractEffect {
    public static EffectSmelt INSTANCE = new EffectSmelt();

    private EffectSmelt() {
        super(GlyphLib.EffectSmeltID, "Smelt");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        double aoeBuff = spellStats.getAoeMultiplier();
        int pierceBuff = spellStats.getBuffCount(AugmentPierce.INSTANCE);
        int maxItemSmelt = (int)Math.round(4.0 * (1.0 + aoeBuff + (double)pierceBuff));
        List itemEntities = world.getEntitiesOfClass(ItemEntity.class, new AABB(rayTraceResult.getEntity().blockPosition()).inflate(aoeBuff + 1.0));
        this.smeltItems(world, itemEntities, maxItemSmelt, spellStats);
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        double aoeBuff = spellStats.getAoeMultiplier();
        int pierceBuff = spellStats.getBuffCount(AugmentPierce.INSTANCE);
        int maxItemSmelt = (int)Math.round(4.0 * (1.0 + aoeBuff + (double)pierceBuff));
        List<BlockPos> posList = SpellUtil.calcAOEBlocks(shooter, rayTraceResult.getBlockPos(), rayTraceResult, spellStats);
        List itemEntities = world.getEntitiesOfClass(ItemEntity.class, new AABB(rayTraceResult.getBlockPos()).inflate(aoeBuff + 1.0));
        this.smeltItems(world, itemEntities, maxItemSmelt, spellStats);
        for (BlockPos pos : posList) {
            this.smeltBlock(world, pos, shooter, rayTraceResult, spellStats, spellContext, resolver);
        }
    }

    public void smeltBlock(Level world, BlockPos pos, LivingEntity shooter, BlockHitResult hitResult, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ItemStack itemstack;
        if (!this.canBlockBeHarvested(spellStats, world, pos)) {
            return;
        }
        BlockState state = world.getBlockState(pos);
        if (!BlockUtil.destroyRespectsClaim((LivingEntity)this.getPlayer(shooter, (ServerLevel)world), world, pos)) {
            return;
        }
        Optional optional = world.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(new ItemStack((ItemLike)state.getBlock().asItem(), 1)), world);
        if (optional.isPresent() && !(itemstack = ((SmeltingRecipe)((RecipeHolder)optional.get()).value()).getResultItem((HolderLookup.Provider)world.registryAccess())).isEmpty()) {
            if (itemstack.getItem() instanceof BlockItem) {
                world.setBlockAndUpdate(pos, ((BlockItem)itemstack.getItem()).getBlock().defaultBlockState());
            } else {
                BlockUtil.destroyBlockSafely(world, pos, false, shooter);
                world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), itemstack.copy()));
                BlockUtil.safelyUpdateState(world, pos);
            }
            ShapersFocus.tryPropagateBlockSpell(new BlockHitResult(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), hitResult.getDirection(), pos, false), world, shooter, spellContext, resolver);
        }
    }

    public void smeltItems(Level world, List<ItemEntity> itemEntities, int maxItemSmelt, SpellStats spellStats) {
        int numSmelted = 0;
        for (ItemEntity itemEntity : itemEntities) {
            ItemStack result;
            if (numSmelted > maxItemSmelt) break;
            Optional optional = spellStats.hasBuff(AugmentDampen.INSTANCE) ? world.getRecipeManager().getRecipeFor(RecipeType.SMOKING, (RecipeInput)new SingleRecipeInput(itemEntity.getItem()), world) : (spellStats.hasBuff(AugmentAmplify.INSTANCE) ? world.getRecipeManager().getRecipeFor(RecipeType.BLASTING, (RecipeInput)new SingleRecipeInput(itemEntity.getItem()), world) : world.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(itemEntity.getItem()), world));
            if (!optional.isPresent() || (result = ((RecipeHolder)optional.get()).value().getResultItem((HolderLookup.Provider)world.registryAccess()).copy()).isEmpty()) continue;
            while (numSmelted < maxItemSmelt && !itemEntity.getItem().isEmpty()) {
                itemEntity.getItem().shrink(1);
                world.addFreshEntity((Entity)new ItemEntity(world, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), result.copy()));
                ++numSmelted;
            }
        }
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentSensitive.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "Smelts blocks and items in the world. AOE will increase the number of items and radius of blocks that can be smelted at once, while Amplify will allow Smelt to work on blocks of higher hardness, Sensitive will make it only smelt items and not blocks.";
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Override
    public int getDefaultManaCost() {
        return 100;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_FIRE);
    }
}

