/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.block.RuneBlock;
import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class EffectRune
extends AbstractEffect {
    public static EffectRune INSTANCE = new EffectRune();

    public EffectRune() {
        super(GlyphLib.EffectRuneID, "Rune");
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos pos = rayTraceResult.getBlockPos();
        pos = rayTraceResult.isInside() ? pos : pos.relative(rayTraceResult.getDirection());
        SpellContext newContext = spellContext.makeChildContext();
        spellContext.setCanceled(true);
        if (world.getBlockState(pos).canBeReplaced()) {
            if (!world.isInWorldBounds(pos)) {
                return;
            }
            BlockState placementState = ((RuneBlock)BlockRegistry.RUNE_BLOCK.get()).getStateForPlacement(new BlockPlaceContext(this.getPlayer(shooter, (ServerLevel)world), InteractionHand.MAIN_HAND, ItemStack.EMPTY, rayTraceResult));
            world.setBlockAndUpdate(pos, placementState);
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof RuneTile) {
                RuneTile runeTile = (RuneTile)blockEntity;
                if (shooter instanceof Player) {
                    runeTile.uuid = shooter.getUUID();
                }
                runeTile.isTemporary = true;
                Spell newSpell = newContext.getSpell();
                Spell.Mutable mutable = newSpell.mutable();
                mutable.recipe.add(0, MethodTouch.INSTANCE);
                runeTile.spell = mutable.immutable();
                runeTile.isSensitive = spellStats.isSensitive();
            }
        }
    }

    @Override
    public int getDefaultManaCost() {
        return 30;
    }

    @Override
    public String getBookDescription() {
        return "Places a rune on the ground that will cast the spell on targets that touch the rune. Unlike runes placed by Runic Chalk, these runes are temporary and cannot be recharged. When using Item Pickup, items are deposited into adjacent inventories. Sensitive will cause the rune to use the Owner's inventory for pickup and usage instead. Players with Magic Find will be able to read spells inscribed on runes.";
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.setOf(AugmentSensitive.INSTANCE);
    }
}

