/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.ILightable;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.LightBlock;
import com.hollingsworth.arsnouveau.common.block.SconceBlock;
import com.hollingsworth.arsnouveau.common.block.tile.LightTile;
import com.hollingsworth.arsnouveau.common.block.tile.TempLightTile;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectLight
extends AbstractEffect
implements IPotionEffect {
    public static EffectLight INSTANCE = new EffectLight();

    private EffectLight() {
        super(GlyphLib.EffectLightID, "Conjure Magelight");
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof ILightable) {
            ILightable iLightable = (ILightable)entity;
            iLightable.onLight((HitResult)rayTraceResult, world, shooter, spellStats, spellContext);
        }
        if (!((entity = rayTraceResult.getEntity()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (!shooter.equals((Object)living)) {
            this.applyConfigPotion(living, (Holder<MobEffect>)MobEffects.GLOWING, spellStats);
        }
        this.applyConfigPotion(living, (Holder<MobEffect>)MobEffects.NIGHT_VISION, spellStats);
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        SignBlockEntity sign;
        BlockPos pos = rayTraceResult.getBlockPos().relative(rayTraceResult.getDirection());
        Player player = this.getPlayer(shooter, (ServerLevel)world);
        if (!BlockUtil.destroyRespectsClaim((LivingEntity)player, world, pos)) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(rayTraceResult.getBlockPos());
        if (blockEntity instanceof ILightable) {
            ILightable lightable = (ILightable)blockEntity;
            lightable.onLight((HitResult)rayTraceResult, world, shooter, spellStats, spellContext);
            return;
        }
        blockEntity = world.getBlockState(rayTraceResult.getBlockPos()).getBlock();
        if (blockEntity instanceof ILightable) {
            ILightable lightable = (ILightable)blockEntity;
            lightable.onLight((HitResult)rayTraceResult, world, shooter, spellStats, spellContext);
            return;
        }
        blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof SignBlockEntity) {
            sign = (SignBlockEntity)blockEntity;
            sign.updateText(a -> sign.getText(true).setHasGlowingText(true), sign.isFacingFrontText(player));
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, sign.getBlockPos(), GameEvent.Context.of((Entity)player, (BlockState)sign.getBlockState()));
        }
        if (world.getBlockState(pos).canBeReplaced() && world.isUnobstructed(((LightBlock)BlockRegistry.LIGHT_BLOCK.get()).defaultBlockState(), pos, CollisionContext.of((Entity)ANFakePlayer.getPlayer((ServerLevel)world))) && world.isInWorldBounds(pos)) {
            BlockState lightBlockState = (BlockState)(spellStats.getDurationMultiplier() != 0.0 ? (LightBlock)BlockRegistry.T_LIGHT_BLOCK.get() : (LightBlock)BlockRegistry.LIGHT_BLOCK.get()).defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER));
            world.setBlockAndUpdate(pos, (BlockState)lightBlockState.setValue(SconceBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.max(0, Math.min(15, 14 + (int)spellStats.getAmpMultiplier())))));
            sign = world.getBlockEntity(pos);
            if (sign instanceof LightTile) {
                LightTile tile = (LightTile)sign;
                tile.color = spellContext.getColors();
                if (tile instanceof TempLightTile) {
                    TempLightTile tempLightTile = (TempLightTile)tile;
                    tempLightTile.lengthModifier = spellStats.getDurationMultiplier();
                }
            }
            world.sendBlockUpdated(pos, world.getBlockState(pos), world.getBlockState(pos), 2);
        }
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addPotionConfig(builder, 30);
        this.addExtendTimeConfig(builder, 8);
    }

    @Override
    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 1);
    }

    @Override
    public int getDefaultManaCost() {
        return 25;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDurationDown.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE);
    }

    @Override
    public String getBookDescription() {
        return "If cast on a block, a permanent light source is created. May be amplified up to Glowstone brightness, or Dampened for a lower light level. When cast on yourself, you will receive night vision. When cast on other entities, they will receive Night Vision and Glowing.";
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.CONJURATION);
    }

    @Override
    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    @Override
    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

