/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.item.inv.ExtractedStack;
import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.potion.IPotionProvider;
import com.hollingsworth.arsnouveau.api.registry.PotionProviderRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.common.block.tile.PotionJarTile;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EffectInfuse
extends AbstractEffect {
    public static EffectInfuse INSTANCE = new EffectInfuse();

    public EffectInfuse() {
        super(GlyphLib.EffectInfuseID, "Infuse");
    }

    @Override
    public void onResolve(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (spellStats.getAoeMultiplier() > 0.0 || spellStats.getDurationMultiplier() > 0.0) {
            this.spawnPotionEntity(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
        } else {
            super.onResolve(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
        }
    }

    public void spawnPotionEntity(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        PotionContents potionData = this.getPotionData(world, shooter, spellContext);
        if (potionData == null) {
            return;
        }
        Item potionItem = spellStats.getAoeMultiplier() > 0.0 ? Items.SPLASH_POTION : Items.LINGERING_POTION;
        ThrownPotion potion = new ThrownPotion(world, shooter);
        ItemStack stack = new ItemStack((ItemLike)potionItem);
        stack.set(DataComponents.POTION_CONTENTS, (Object)potionData);
        potion.setItem(stack);
        potion.setPos(rayTraceResult.getLocation());
        world.addFreshEntity((Entity)potion);
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        PotionContents potionData = this.getPotionData(world, shooter, spellContext);
        if (potionData == null) {
            return;
        }
        PotionUtil.applyContents(potionData, shooter, shooter, livingEntity);
    }

    @Nullable
    public PotionContents getPotionData(Level world, @NotNull LivingEntity shooter, SpellContext spellContext) {
        BlockEntity jarEntity;
        PotionContents potionData = null;
        InventoryManager manager = spellContext.getCaster().getInvManager();
        ExtractedStack extractedFlask = manager.extractItem(i -> {
            IPotionProvider provider = PotionProviderRegistry.from(i);
            return provider != null && !provider.isEmpty((ItemStack)i);
        }, 1);
        if (!extractedFlask.isEmpty()) {
            IPotionProvider provider = PotionProviderRegistry.from(extractedFlask.stack);
            potionData = provider.getPotionData(extractedFlask.stack);
            provider.consumeUses(extractedFlask.stack, 1, shooter);
            extractedFlask.returnOrDrop(world, shooter.getOnPos());
        } else {
            ExtractedStack potion = manager.extractItem(i -> i.getItem() instanceof PotionItem, 1);
            if (!potion.isEmpty()) {
                ItemStack stack = potion.getStack();
                potionData = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
                stack.shrink(1);
                potion.replaceAndReturnOrDrop(new ItemStack((ItemLike)Items.GLASS_BOTTLE), world, shooter.getOnPos());
            }
        }
        if (potionData == null && (jarEntity = spellContext.getCaster().getNearbyBlockEntity(i -> {
            PotionJarTile jar;
            return i instanceof PotionJarTile && (jar = (PotionJarTile)i).getAmount() > 100;
        })) instanceof PotionJarTile) {
            PotionJarTile jar = (PotionJarTile)jarEntity;
            potionData = jar.getData();
            jar.remove(100);
        }
        return potionData;
    }

    @Override
    public int getDefaultManaCost() {
        return 30;
    }

    @Override
    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.setOf(AugmentAOE.INSTANCE, AugmentExtendTime.INSTANCE);
    }

    @Override
    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAOE.INSTANCE.getRegistryName(), 1);
        defaults.put(AugmentExtendTime.INSTANCE.getRegistryName(), 1);
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Override
    public String getBookDescription() {
        return "Infuses a target with a potion or flask from your inventory. If augmented with AOE, a splash potion will spawn at the location. If augmented with Extend Time, a lingering potion will spawn at the location. Caster blocks may pull from adjacent Potion Jars to cast infuse.";
    }
}

