/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectFreeze
extends AbstractEffect
implements IPotionEffect {
    public static EffectFreeze INSTANCE = new EffectFreeze();

    private EffectFreeze() {
        super(GlyphLib.EffectFreezeID, "Freeze");
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        BlockPos pos = rayTraceResult.getBlockPos();
        for (BlockPos p : SpellUtil.calcAOEBlocks(shooter, pos, rayTraceResult, spellStats.getAoeMultiplier(), spellStats.getBuffCount(AugmentPierce.INSTANCE))) {
            BlockPos affectedPos = this.extinguishOrFreeze(world, p, spellStats);
            if (affectedPos != null) {
                ShapersFocus.tryPropagateBlockSpell(new BlockHitResult(new Vec3((double)affectedPos.getX(), (double)affectedPos.getY(), (double)affectedPos.getZ()), rayTraceResult.getDirection(), affectedPos, false), world, shooter, spellContext, resolver);
            }
            for (Direction d : Direction.values()) {
                BlockPos relative = p.relative(d);
                affectedPos = this.extinguishOrFreeze(world, relative, spellStats);
                if (affectedPos == null) continue;
                ShapersFocus.tryPropagateBlockSpell(new BlockHitResult(new Vec3((double)affectedPos.getX(), (double)affectedPos.getY(), (double)affectedPos.getZ()), rayTraceResult.getDirection(), affectedPos, false), world, shooter, spellContext, resolver);
            }
        }
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        this.applyConfigPotion(living, (Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, spellStats);
    }

    @Nullable
    public BlockPos extinguishOrFreeze(Level world, BlockPos p, SpellStats spellStats) {
        BlockState hitState = world.getBlockState(p);
        BlockState aboveState = world.getBlockState(p.above());
        FluidState aboveFluidstate = world.getFluidState(p.above());
        if (aboveFluidstate.getType() == Fluids.WATER && aboveState.getBlock() instanceof LiquidBlock) {
            if (spellStats.isSensitive()) {
                world.setBlockAndUpdate(p.above(), Blocks.FROSTED_ICE.defaultBlockState());
            } else {
                world.setBlockAndUpdate(p.above(), Blocks.ICE.defaultBlockState());
            }
            return p.above();
        }
        if (aboveFluidstate.getType() == Fluids.LAVA && aboveState.getBlock() instanceof LiquidBlock) {
            world.setBlockAndUpdate(p.above(), Blocks.OBSIDIAN.defaultBlockState());
            return p.above();
        }
        if (aboveFluidstate.getType() == Fluids.FLOWING_LAVA && aboveState.getBlock() instanceof LiquidBlock) {
            world.setBlockAndUpdate(p.above(), Blocks.COBBLESTONE.defaultBlockState());
            return p.above();
        }
        if (aboveState.is(BlockTags.FIRE)) {
            world.destroyBlock(p.above(), false);
            return p.above();
        }
        if (hitState.getBlock() == Blocks.ICE) {
            world.setBlock(p, Blocks.PACKED_ICE.defaultBlockState(), 3);
            return p;
        }
        if (hitState.getBlock() == Blocks.PACKED_ICE) {
            world.setBlock(p, Blocks.BLUE_ICE.defaultBlockState(), 3);
            return p;
        }
        return null;
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addPotionConfig(builder, 10);
        this.addExtendTimeConfig(builder, 5);
    }

    @Override
    public int getDefaultManaCost() {
        return 15;
    }

    @Override
    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentSensitive.INSTANCE.getRegistryName(), 1);
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        HashSet<AbstractAugment> augments = new HashSet<AbstractAugment>(this.getPotionAugments());
        augments.add(AugmentAOE.INSTANCE);
        augments.add(AugmentPierce.INSTANCE);
        augments.add(AugmentSensitive.INSTANCE);
        return augments;
    }

    @Override
    public String getBookDescription() {
        return "Freezes water or lava in a small area or slows a target for a short time. Freeze on Ice will turn it into Packed Ice, and Packed Ice into Blue Ice. Sensitive will turn water into Frosted Ice and will vanish after a short time.";
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_WATER);
    }

    @Override
    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    @Override
    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }
}

