/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.event.DispelEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.lib.PotionEffectTags;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;

public class EffectDispel
extends AbstractEffect {
    public static EffectDispel INSTANCE = new EffectDispel();

    private EffectDispel() {
        super(GlyphLib.EffectDispelID, "Dispel");
    }

    @Override
    public void onResolveEntity(@NotNull EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            Collection effects = entity2.getActiveEffects();
            MobEffectInstance[] array = effects.toArray(new MobEffectInstance[0]);
            Optional blacklist = world.registryAccess().registryOrThrow(Registries.MOB_EFFECT).getTag(PotionEffectTags.DISPEL_DENY);
            Optional whitelist = world.registryAccess().registryOrThrow(Registries.MOB_EFFECT).getTag(PotionEffectTags.DISPEL_ALLOW);
            for (MobEffectInstance e : array) {
                if (e.getCures().contains(EffectCures.MILK)) {
                    if (blacklist.isPresent() && ((HolderSet.Named)blacklist.get()).stream().anyMatch(effect -> effect.value() == e.getEffect())) continue;
                    entity2.removeEffect(e.getEffect());
                    continue;
                }
                if (!whitelist.isPresent() || !((HolderSet.Named)whitelist.get()).stream().anyMatch(effect -> effect.value() == e.getEffect())) continue;
                entity2.removeEffect(e.getEffect());
            }
            if (!entity2.isAlive() || entity2.getHealth() <= 0.0f || entity2.isRemoved()) {
                return;
            }
            DispelEvent.Pre dispelEvent = (DispelEvent.Pre)NeoForge.EVENT_BUS.post((Event)new DispelEvent.Pre((HitResult)rayTraceResult, world, shooter, spellStats, spellContext));
            if (dispelEvent.isCanceled()) {
                return;
            }
            if (entity2 instanceof IDispellable) {
                IDispellable iDispellable = (IDispellable)entity2;
                iDispellable.onDispel(shooter);
            }
            NeoForge.EVENT_BUS.post((Event)new DispelEvent.Post((HitResult)rayTraceResult, world, shooter, spellStats, spellContext));
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        IDispellable dispellable;
        DispelEvent.Pre dispelEvent = (DispelEvent.Pre)NeoForge.EVENT_BUS.post((Event)new DispelEvent.Pre((HitResult)rayTraceResult, world, shooter, spellStats, spellContext));
        if (dispelEvent.isCanceled()) {
            return;
        }
        BlockState blockState = world.getBlockState(rayTraceResult.getBlockPos());
        if (blockState instanceof IDispellable) {
            dispellable = (IDispellable)blockState;
            dispellable.onDispel(shooter);
        }
        if ((blockState = world.getBlockEntity(rayTraceResult.getBlockPos())) instanceof IDispellable) {
            dispellable = (IDispellable)blockState;
            dispellable.onDispel(shooter);
        }
        NeoForge.EVENT_BUS.post((Event)new DispelEvent.Post((HitResult)rayTraceResult, world, shooter, spellStats, spellContext));
    }

    @Override
    public int getDefaultManaCost() {
        return 30;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "Removes any potion effects on the target. When used on a witch at half health, the witch will vanish in return for a Wixie shard. Will also dispel tamed summons back into their charm.";
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ABJURATION);
    }
}

