/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectCut
extends AbstractEffect
implements IDamageEffect {
    public static EffectCut INSTANCE = new EffectCut();

    private EffectCut() {
        super(GlyphLib.EffectCutID, "Cut");
    }

    @Override
    public boolean canDamage(LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver, @NotNull Entity entity) {
        return IDamageEffect.super.canDamage(shooter, stats, spellContext, resolver, entity) && !(entity instanceof IShearable);
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Entity entity = rayTraceResult.getEntity();
        if (entity instanceof IShearable) {
            IShearable shearable = (IShearable)entity;
            ItemStack shears = new ItemStack((ItemLike)Items.SHEARS);
            this.applyEnchantments(world, spellStats, shears);
            if (shearable.isShearable(this.getPlayer(shooter, (ServerLevel)world), shears, world, entity.blockPosition())) {
                List items = shearable.onSheared(this.getPlayer(shooter, (ServerLevel)world), shears, world, entity.blockPosition());
                items.forEach(i -> world.addFreshEntity((Entity)new ItemEntity(world, entity.getX(), entity.getY(), entity.getZ(), i)));
            }
        } else {
            float damage = (float)((Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier());
            this.attemptDamage(world, shooter, spellStats, spellContext, resolver, entity, this.buildDamageSource(world, shooter), damage);
        }
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        for (BlockPos p : SpellUtil.calcAOEBlocks(shooter, rayTraceResult.getBlockPos(), rayTraceResult, spellStats.getAoeMultiplier(), spellStats.getBuffCount(AugmentPierce.INSTANCE))) {
            if (spellStats.getBuffCount(AugmentAmplify.INSTANCE) > 0) {
                this.doStrip(p, rayTraceResult, world, shooter, spellStats, spellContext, resolver);
                continue;
            }
            this.doShear(p, rayTraceResult, world, shooter, spellStats, spellContext, resolver);
        }
    }

    private boolean dupeCheck(Level world, BlockPos pos) {
        BlockEntity be = world.getBlockEntity(pos);
        return be != null && (world.getCapability(Capabilities.ItemHandler.BLOCK, pos, null) != null || be instanceof Container);
    }

    public void doStrip(BlockPos p, BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ItemStack axe = new ItemStack((ItemLike)Items.DIAMOND_AXE);
        this.applyEnchantments(world, spellStats, axe);
        ANFakePlayer entity = ANFakePlayer.getPlayer((ServerLevel)world);
        entity.setItemInHand(InteractionHand.MAIN_HAND, axe);
        if (this.dupeCheck(world, p)) {
            return;
        }
        entity.setPos(p.getX(), p.getY(), p.getZ());
        world.getBlockState(p).useItemOn(axe, world, (Player)entity, InteractionHand.MAIN_HAND, rayTraceResult);
        axe.useOn(new UseOnContext((Player)entity, InteractionHand.MAIN_HAND, rayTraceResult));
    }

    public void doShear(BlockPos p, BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        IShearable shearable;
        ItemStack shears = new ItemStack((ItemLike)Items.SHEARS);
        this.applyEnchantments(world, spellStats, shears);
        Block block = world.getBlockState(p).getBlock();
        if (block instanceof IShearable && (shearable = (IShearable)block).isShearable(this.getPlayer(shooter, (ServerLevel)world), shears, world, p)) {
            List items = shearable.onSheared(this.getPlayer(shooter, (ServerLevel)world), shears, world, p);
            items.forEach(i -> world.addFreshEntity((Entity)new ItemEntity(world, (double)p.getX(), (double)p.getY(), (double)p.getZ(), i)));
        }
        ANFakePlayer entity = ANFakePlayer.getPlayer((ServerLevel)world);
        entity.setItemInHand(InteractionHand.MAIN_HAND, shears);
        if (this.dupeCheck(world, p)) {
            return;
        }
        entity.setPos(p.getX(), p.getY(), p.getZ());
        world.getBlockState(p).useItemOn(shears, world, (Player)entity, InteractionHand.MAIN_HAND, rayTraceResult);
        shears.useOn(new UseOnContext((Player)entity, InteractionHand.MAIN_HAND, rayTraceResult));
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 1.0);
        this.addAmpConfig(builder, 1.0);
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentExtract.INSTANCE, AugmentFortune.INSTANCE, AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE);
    }

    @Override
    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }

    @Override
    public String getBookDescription() {
        return "Simulates using shears on entities and blocks, or damages non-shearable entities for a small amount. Amplify will simulate using an Axe instead of Shears. For simulating breaking with shears, see Break and Sensitive. Costs nothing.";
    }

    @Override
    public int getDefaultManaCost() {
        return 0;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.MANIPULATION);
    }
}

