/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.effect;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.SpecialSingleInputRecipe;
import com.hollingsworth.arsnouveau.common.items.curios.ShapersFocus;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.setup.registry.DamageTypesRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectCrush
extends AbstractEffect
implements IDamageEffect {
    public static EffectCrush INSTANCE = new EffectCrush();

    private EffectCrush() {
        super(GlyphLib.EffectCrushID, "Crush");
    }

    @Override
    public void onResolve(HitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        if (spellStats.isSensitive()) {
            double aoeBuff = spellStats.getAoeMultiplier();
            int pierceBuff = spellStats.getBuffCount(AugmentPierce.INSTANCE);
            int maxItemCrush = (int)(4.0 + 4.0 * aoeBuff + (double)(4 * pierceBuff));
            List itemEntities = world.getEntitiesOfClass(ItemEntity.class, new AABB(BlockPos.containing((Position)rayTraceResult.getLocation())).inflate(aoeBuff + 1.0));
            if (!itemEntities.isEmpty()) {
                EffectCrush.crushItems(world, itemEntities, maxItemCrush);
            }
        } else {
            super.onResolve(rayTraceResult, world, shooter, spellStats, spellContext, resolver);
        }
    }

    @Override
    public void onResolveEntity(EntityHitResult rayTraceResult, Level level, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        float damage = (float)((rayTraceResult.getEntity().isSwimming() ? (Double)this.DAMAGE.get() * 3.0 : (Double)this.DAMAGE.get()) + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier());
        this.attemptDamage(level, shooter, spellStats, spellContext, resolver, rayTraceResult.getEntity(), this.buildDamageSource(level, shooter), damage);
    }

    @Override
    public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        return DamageUtil.source((LevelAccessor)world, DamageTypesRegistry.CRUSH, (Entity)shooter);
    }

    @Override
    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        List recipes = world.getRecipeManager().getAllRecipesFor((RecipeType)RecipeRegistry.CRUSH_TYPE.get());
        SpecialSingleInputRecipe lastHit = null;
        for (BlockPos p : SpellUtil.calcAOEBlocks(shooter, rayTraceResult.getBlockPos(), rayTraceResult, spellStats.getAoeMultiplier(), spellStats.getBuffCount(AugmentPierce.INSTANCE))) {
            BlockState state = world.getBlockState(p);
            Item item = state.getBlock().asItem();
            if (lastHit == null || !lastHit.matches(item.getDefaultInstance(), world)) {
                lastHit = null;
                for (RecipeHolder recipe : recipes) {
                    if (!((CrushRecipe)recipe.value()).matches(item.getDefaultInstance(), world)) continue;
                    lastHit = (CrushRecipe)recipe.value();
                    break;
                }
            }
            if (lastHit == null) continue;
            List<ItemStack> outputs = ((CrushRecipe)lastHit).getRolledOutputs(world.random);
            boolean placedBlock = false;
            for (ItemStack i : outputs) {
                Item item2;
                if (!placedBlock && (item2 = i.getItem()) instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item2;
                    if (!((CrushRecipe)lastHit).shouldSkipBlockPlace()) {
                        world.setBlockAndUpdate(p, blockItem.getBlock().defaultBlockState());
                        placedBlock = true;
                        i.shrink(1);
                        ShapersFocus.tryPropagateBlockSpell(new BlockHitResult(new Vec3((double)p.getX(), (double)p.getY(), (double)p.getZ()), rayTraceResult.getDirection(), p, false), world, shooter, spellContext, resolver);
                    }
                }
                if (i.isEmpty()) continue;
                world.addFreshEntity((Entity)new ItemEntity(world, (double)p.getX() + 0.5, (double)p.getY(), (double)p.getZ() + 0.5, i));
            }
            if (placedBlock) continue;
            world.setBlockAndUpdate(p, Blocks.AIR.defaultBlockState());
            ShapersFocus.tryPropagateBlockSpell(new BlockHitResult(new Vec3((double)p.getX(), (double)p.getY(), (double)p.getZ()), rayTraceResult.getDirection(), p, false), world, shooter, spellContext, resolver);
        }
    }

    public static void crushItems(Level world, List<ItemEntity> itemEntities, int maxItemCrush) {
        List recipes = world.getRecipeManager().getAllRecipesFor((RecipeType)RecipeRegistry.CRUSH_TYPE.get());
        SpecialSingleInputRecipe lastHit = null;
        int itemsCrushed = 0;
        for (ItemEntity IE : itemEntities) {
            if (itemsCrushed > maxItemCrush) break;
            ItemStack stack = IE.getItem();
            Item item = stack.getItem();
            if (lastHit == null || !lastHit.matches(item.getDefaultInstance(), world)) {
                RecipeHolder holder = recipes.stream().filter(recipe -> ((CrushRecipe)recipe.value()).matches(item.getDefaultInstance(), world)).findFirst().orElse(null);
                SpecialSingleInputRecipe specialSingleInputRecipe = lastHit = holder == null ? null : (CrushRecipe)holder.value();
            }
            if (lastHit == null) continue;
            while (!stack.isEmpty() && itemsCrushed <= maxItemCrush) {
                List<ItemStack> outputs = ((CrushRecipe)lastHit).getRolledOutputs(world.random);
                stack.shrink(1);
                ++itemsCrushed;
                for (ItemStack result : outputs) {
                    world.addFreshEntity((Entity)new ItemEntity(world, IE.getX(), IE.getY(), IE.getZ(), result.copy()));
                }
            }
        }
    }

    @Override
    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 3.0);
        this.addAmpConfig(builder, 1.0);
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentAOE.INSTANCE, AugmentPierce.INSTANCE, AugmentFortune.INSTANCE, AugmentSensitive.INSTANCE);
    }

    @Override
    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }

    @Override
    public String getBookDescription() {
        return "Turns stone into gravel, and gravel into sand. Will also crush flowers into bonus dye. Need Sensitive to work on items. For full recipe support, see JEI. Will also harm entities and deals bonus damage to entities that are swimming.";
    }

    @Override
    public int getDefaultManaCost() {
        return 30;
    }

    @Override
    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Override
    @NotNull
    public Set<SpellSchool> getSchools() {
        return this.setOf(SpellSchools.ELEMENTAL_EARTH);
    }
}

