/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.ritual;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.util.MathUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.lib.RitualLib;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class RitualMoonfall
extends AbstractRitual {
    @Override
    protected void tick() {
        ParticleUtil.spawnRitualSkyEffect(this, this.tile, this.rand, new ParticleColor.IntWrapper(50 + this.rand.nextInt(50), 50 + this.rand.nextInt(50), 200 + this.rand.nextInt(55)));
        Level level = this.getWorld();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (world.getDayTime() % 24000L < 13000L && world.getDayTime() % 24000L >= 0L) {
                world.setDayTime(world.getDayTime() + 100L);
                for (ServerPlayer player : world.players()) {
                    player.connection.send((Packet)new ClientboundSetTimePacket(world.getGameTime(), world.getDayTime(), world.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
                }
            } else {
                this.incrementProgress();
            }
            if (world.getGameTime() % 20L == 0L) {
                this.incrementProgress();
                if (this.getProgress() >= 18) {
                    world.setDayTime(MathUtil.getNextDaysTime((Level)world, MathUtil.NIGHT_TIME));
                    for (ServerPlayer player : world.players()) {
                        player.connection.send((Packet)new ClientboundSetTimePacket(world.getGameTime(), world.getDayTime(), world.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
                    }
                    this.setFinished();
                }
            }
        }
    }

    @Override
    public String getLangName() {
        return "Moonfall";
    }

    @Override
    public String getLangDescription() {
        return "Sets the time to night.";
    }

    @Override
    public ResourceLocation getRegistryName() {
        return ArsNouveau.prefix(RitualLib.MOONFALL);
    }

    @Override
    public ParticleColor getCenterColor() {
        return new ParticleColor(this.rand.nextInt(25), this.rand.nextInt(25), this.rand.nextInt(255));
    }
}

