/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.perk;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.perk.Perk;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class RepairingPerk
extends Perk {
    public static final RepairingPerk INSTANCE = new RepairingPerk(ArsNouveau.prefix("thread_repairing"));

    public RepairingPerk(ResourceLocation key) {
        super(key);
    }

    public static void attemptRepair(ItemStack stack, LivingEntity entity) {
        if (entity.level.getGameTime() % 200L != 0L || stack.getDamageValue() <= 0) {
            return;
        }
        double repairLevel = PerkUtil.countForPerk(INSTANCE, entity);
        ManaCap cap = CapabilityRegistry.getMana(entity);
        if (cap != null) {
            if (cap.getCurrentMana() < 20.0) {
                return;
            }
            cap.removeMana(20.0);
            stack.setDamageValue(stack.getDamageValue() - Math.min(stack.getDamageValue(), (int)repairLevel + 1));
        }
    }

    @Override
    public String getLangName() {
        return "Repairing";
    }

    @Override
    public String getLangDescription() {
        return "Allows the wearer to repair ANY magical armor or enchanters item by consuming Mana over time. Additional levels increase the speed at which the items repair. This perk applies to all relevant items, not only the item with this perk.";
    }
}

