/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.common.network.ITagSyncable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class PacketSyncTag
extends AbstractPacket {
    public CompoundTag tag;
    public int entityId;
    public static final CustomPacketPayload.Type<PacketSyncTag> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("sync_tag"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSyncTag> CODEC = StreamCodec.ofMember(PacketSyncTag::toBytes, PacketSyncTag::decode);

    public PacketSyncTag(CompoundTag tag, int entityId) {
        this.tag = tag;
        this.entityId = entityId;
    }

    public static PacketSyncTag decode(RegistryFriendlyByteBuf buf) {
        return new PacketSyncTag(buf.readNbt(), buf.readInt());
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeNbt((Tag)this.tag);
        buf.writeInt(this.entityId);
    }

    @Override
    public void onClientReceived(Minecraft mc, Player player) {
        ClientLevel world = mc.level;
        Entity entity = world.getEntity(this.entityId);
        if (entity instanceof ITagSyncable) {
            ITagSyncable tagSyncable = (ITagSyncable)entity;
            tagSyncable.onTagSync(this.tag);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

