/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOpenSpellBook;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateBookGUI;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PacketSetSound
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketSetSound> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("set_sound"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSetSound> CODEC = StreamCodec.ofMember(PacketSetSound::toBytes, PacketSetSound::new);
    int castSlot;
    ConfiguredSpellSound sound;
    boolean mainHand;

    public PacketSetSound(int castSlot, @NotNull ConfiguredSpellSound sound, boolean mainHand) {
        this.castSlot = castSlot;
        this.sound = sound;
        this.mainHand = mainHand;
    }

    public PacketSetSound(RegistryFriendlyByteBuf buf) {
        this.castSlot = buf.readInt();
        this.sound = (ConfiguredSpellSound)ConfiguredSpellSound.STREAM.decode((Object)buf);
        this.mainHand = buf.readBoolean();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.castSlot);
        ConfiguredSpellSound.STREAM.encode((Object)buf, (Object)this.sound);
        buf.writeBoolean(this.mainHand);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        ItemStack stack = player.getItemInHand(this.mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        if (stack.getItem() instanceof SpellBook) {
            ((AbstractCaster)SpellCasterRegistry.from(stack).setSound(this.sound, this.castSlot)).saveToStack(stack);
            Networking.sendToPlayerClient(new PacketUpdateBookGUI(stack), player);
            Networking.sendToPlayerClient(new PacketOpenSpellBook(this.mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND), player);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

