/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.camera.CameraController;
import com.hollingsworth.arsnouveau.common.entity.ScryerCamera;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class PacketSetCameraView
extends AbstractPacket {
    public static final CustomPacketPayload.Type<PacketSetCameraView> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("set_camera_view"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSetCameraView> CODEC = StreamCodec.ofMember(PacketSetCameraView::toBytes, PacketSetCameraView::new);
    private int id;

    public PacketSetCameraView() {
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.id);
    }

    public PacketSetCameraView(Entity camera) {
        this.id = camera.getId();
    }

    public PacketSetCameraView(RegistryFriendlyByteBuf buf) {
        this.id = buf.readVarInt();
    }

    @Override
    public void onClientReceived(Minecraft mc, Player player) {
        Entity entity = mc.level.getEntity(this.id);
        boolean isCamera = entity instanceof ScryerCamera;
        if (isCamera || entity instanceof Player) {
            mc.setCameraEntity(entity);
            if (isCamera) {
                CameraController.previousCameraType = mc.options.getCameraType();
                mc.options.setCameraType(CameraType.FIRST_PERSON);
                CameraController.setRenderPosition(entity);
            } else if (CameraController.previousCameraType != null) {
                mc.options.setCameraType(CameraController.previousCameraType);
            }
            mc.levelRenderer.allChanged();
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

