/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mixin.rewind;

import com.hollingsworth.arsnouveau.common.entity.debug.FixedStack;
import com.hollingsworth.arsnouveau.common.event.timed.IRewindable;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectRewind;
import com.hollingsworth.arsnouveau.common.spell.rewind.RewindEntityData;
import java.util.Stack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class RewindEntityMixin
implements IRewindable {
    @Shadow
    public Level level;
    @Unique
    public Stack<RewindEntityData> ars_Nouveau$motions = new FixedStack<RewindEntityData>(EffectRewind.INSTANCE.getEntityMaxTrackingTicks());
    @Unique
    public boolean an_isRewinding = false;

    @Shadow
    public abstract Vec3 getDeltaMovement();

    @Shadow
    public abstract Level level();

    @Shadow
    public abstract void remove(Entity.RemovalReason var1);

    @Shadow
    public abstract boolean removeTag(String var1);

    @Shadow
    public abstract Vec3 position();

    @Inject(method={"baseTick"}, at={@At(value="TAIL")})
    public void onTick(CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (!EffectRewind.shouldRecordData(entity, this) || this.level == null) {
            return;
        }
        float health = 0.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            health = living.getHealth();
        }
        RewindEntityData data = new RewindEntityData(this.level.getGameTime(), this.getDeltaMovement(), this.position(), health);
        this.ars_Nouveau$motions.push(data);
    }

    @Inject(method={"setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void anSetDeltaMovement(Vec3 pDeltaMovement, CallbackInfo ci) {
        if (!EffectRewind.shouldAllowMovement(this)) {
            ci.cancel();
        }
    }

    @Inject(method={"setDeltaMovement(DDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void anSetDeltaMovement(double pX, double pY, double pZ, CallbackInfo ci) {
        if (!EffectRewind.shouldAllowMovement(this)) {
            ci.cancel();
        }
    }

    @Override
    public Stack<RewindEntityData> getMotions() {
        return this.ars_Nouveau$motions;
    }

    @Override
    public void setRewinding(boolean rewinding) {
        this.an_isRewinding = rewinding;
    }

    @Override
    public boolean isRewinding() {
        return this.an_isRewinding;
    }
}

