/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mixin.perks;

import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.perk.DepthsPerk;
import com.hollingsworth.arsnouveau.common.perk.JumpHeightPerk;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class PerkLivingEntity {
    @Inject(method={"decreaseAirSupply"}, at={@At(value="HEAD")}, cancellable=true)
    protected void decreaseAirSupply(int pCurrentAir, CallbackInfoReturnable<Integer> cir) {
        LivingEntity thisEntity = (LivingEntity)this;
        int numDepths = PerkUtil.countForPerk(DepthsPerk.INSTANCE, thisEntity);
        if (numDepths >= 3 || thisEntity.getRandom().nextDouble() <= (double)numDepths * 0.33) {
            cir.setReturnValue((Object)thisEntity.getAirSupply());
        }
    }

    @Inject(method={"getJumpBoostPower"}, at={@At(value="RETURN")}, cancellable=true)
    protected void getJumpPower(CallbackInfoReturnable<Float> cir) {
        LivingEntity thisEntity = (LivingEntity)this;
        cir.setReturnValue((Object)Float.valueOf(cir.getReturnValueF() + (float)PerkUtil.countForPerk(JumpHeightPerk.INSTANCE, thisEntity) * 0.1f));
    }
}

