/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mixin.camera;

import com.hollingsworth.arsnouveau.common.entity.ScryerCamera;
import com.hollingsworth.arsnouveau.common.util.CameraUtil;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ChunkMap.TrackedEntity.class}, priority=1100)
public abstract class TrackedEntityMixin {
    @Shadow
    @Final
    ServerEntity serverEntity;
    @Shadow
    @Final
    Entity entity;
    @Unique
    private boolean shouldBeSent = false;

    @Inject(method={"updatePlayer"}, at={@At(value="FIELD", target="Lnet/minecraft/world/phys/Vec3;x:D", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private void onUpdatePlayer(ServerPlayer player, CallbackInfo ci, Vec3 vec3, int i, double d0, Vec3 unused, double viewDistance) {
        if (CameraUtil.isPlayerMountedOnCamera((LivingEntity)player)) {
            Vec3 relativePosToCamera = player.getCamera().position().subtract(this.entity.position());
            if (relativePosToCamera.x >= -viewDistance && relativePosToCamera.x <= viewDistance && relativePosToCamera.z >= -viewDistance && relativePosToCamera.z <= viewDistance) {
                this.shouldBeSent = true;
            }
        }
    }

    @ModifyVariable(method={"updatePlayer"}, name={"flag"}, at=@At(value="JUMP", opcode=153, shift=At.Shift.BEFORE, ordinal=1))
    public boolean modifyFlag(boolean original) {
        boolean shouldBeSent = this.shouldBeSent;
        this.shouldBeSent = false;
        return this.entity instanceof ScryerCamera || original || shouldBeSent;
    }
}

