/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mixin.camera;

import com.hollingsworth.arsnouveau.common.entity.ScryerCamera;
import com.hollingsworth.arsnouveau.common.util.CameraUtil;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PlayerList.class}, priority=1100)
public class PlayerListMixin {
    @Inject(method={"broadcast"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/server/level/ServerPlayer;getZ()D")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private void broadcastToCameras(Player except, double x, double y, double z, double radius, ResourceKey<Level> dimension, Packet<?> packet, CallbackInfo callback, int iteration, ServerPlayer player) {
        if (CameraUtil.isPlayerMountedOnCamera((LivingEntity)player)) {
            double dZ;
            double dY;
            ScryerCamera camera = (ScryerCamera)player.getCamera();
            double dX = x - camera.getX();
            if (dX * dX + (dY = y - camera.getY()) * dY + (dZ = z - camera.getZ()) * dZ < radius * radius) {
                player.connection.send(packet);
            }
            callback.cancel();
        }
    }
}

