/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.mixin.camera;

import com.hollingsworth.arsnouveau.common.camera.ANIChunkStorageProvider;
import com.hollingsworth.arsnouveau.common.camera.CameraController;
import com.hollingsworth.arsnouveau.common.util.CameraUtil;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientChunkCache.class}, priority=1100)
public abstract class ClientChunkCacheMixin
implements ANIChunkStorageProvider {
    @Shadow
    volatile ClientChunkCache.Storage storage;
    @Shadow
    @Final
    ClientLevel level;

    @Shadow
    private static boolean isValidChunk(LevelChunk chunk, int x, int z) {
        throw new IllegalStateException("Shadowing isValidChunk did not work!");
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void onInit(ClientLevel level, int viewDistance, CallbackInfo ci) {
        CameraController.setCameraStorage(this.ANnewStorage(Math.max(2, viewDistance) + 3));
    }

    @Inject(method={"updateViewRadius"}, at={@At(value="HEAD")})
    public void onUpdateViewRadius(int viewDistance, CallbackInfo ci) {
        CameraController.setCameraStorage(this.ANnewStorage(Math.max(2, viewDistance) + 3));
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")})
    public void onDrop(ChunkPos chunkPos, CallbackInfo ci) {
        int i;
        LevelChunk chunk;
        int x = chunkPos.x;
        int z = chunkPos.z;
        ClientChunkCache.Storage cameraStorage = CameraController.getCameraStorage();
        if (cameraStorage.inRange(x, z) && (chunk = cameraStorage.getChunk(i = cameraStorage.getIndex(x, z))) != null && chunk.getPos().x == x && chunk.getPos().z == z) {
            NeoForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((ChunkAccess)chunk));
            cameraStorage.replace(i, chunk, null);
        }
    }

    @Inject(method={"replaceWithPacketData"}, at={@At(value="HEAD")}, cancellable=true)
    private void onReplace(int x, int z, FriendlyByteBuf buffer, CompoundTag chunkTag, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> tagOutputConsumer, CallbackInfoReturnable<LevelChunk> callback) {
        ClientChunkCache.Storage cameraStorage = CameraController.getCameraStorage();
        if (CameraUtil.isPlayerMountedOnCamera((LivingEntity)Minecraft.getInstance().player) && !this.storage.inRange(x, z) && cameraStorage.inRange(x, z)) {
            int index = cameraStorage.getIndex(x, z);
            LevelChunk chunk = cameraStorage.getChunk(index);
            ChunkPos chunkPos = new ChunkPos(x, z);
            if (!ClientChunkCacheMixin.isValidChunk(chunk, x, z)) {
                chunk = new LevelChunk((Level)this.level, chunkPos);
                chunk.replaceWithPacketData(buffer, chunkTag, tagOutputConsumer);
                cameraStorage.replace(index, chunk);
            } else {
                chunk.replaceWithPacketData(buffer, chunkTag, tagOutputConsumer);
            }
            this.level.onChunkLoaded(chunkPos);
            NeoForge.EVENT_BUS.post((Event)new ChunkEvent.Load((ChunkAccess)chunk, false));
            callback.setReturnValue((Object)chunk);
        }
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/level/chunk/status/ChunkStatus;Z)Lnet/minecraft/world/level/chunk/ChunkAccess;"}, at={@At(value="TAIL")}, cancellable=true)
    private void onGetChunk(int x, int z, ChunkStatus requiredStatus, boolean load, CallbackInfoReturnable<LevelChunk> callback) {
        LevelChunk chunk;
        if (CameraUtil.isPlayerMountedOnCamera((LivingEntity)Minecraft.getInstance().player) && !this.storage.inRange(x, z) && CameraController.getCameraStorage().inRange(x, z) && (chunk = CameraController.getCameraStorage().getChunk(CameraController.getCameraStorage().getIndex(x, z))) != null && chunk.getPos().x == x && chunk.getPos().z == z) {
            callback.setReturnValue((Object)chunk);
        }
    }
}

