/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSlotMap;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.NotEnoughManaPacket;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TomeCasterData
extends AbstractCaster<TomeCasterData> {
    public static final MapCodec<TomeCasterData> CODEC = SpellCaster.createCodec(TomeCasterData::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, TomeCasterData> STREAM_CODEC = TomeCasterData.createStream(TomeCasterData::new);

    @Override
    public MapCodec<TomeCasterData> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, TomeCasterData> streamCodec() {
        return STREAM_CODEC;
    }

    public TomeCasterData() {
    }

    public TomeCasterData(Integer slot, String flavorText, Boolean isHidden, String hiddenText, int maxSlots) {
        super(slot, flavorText, isHidden, hiddenText, maxSlots);
    }

    public TomeCasterData(Integer slot, String flavorText, Boolean isHidden, String hiddenText, int maxSlots, SpellSlotMap spells) {
        super(slot, flavorText, isHidden, hiddenText, maxSlots, spells);
    }

    @Override
    public SpellResolver getSpellResolver(SpellContext context, Level worldIn, LivingEntity playerIn, InteractionHand handIn) {
        return new SpellResolver(this, context){

            @Override
            protected boolean enoughMana(LivingEntity entity) {
                Player player;
                boolean canCast;
                int totalCost = this.getResolveCost();
                ManaCap manaCap = CapabilityRegistry.getMana(entity);
                if (manaCap == null) {
                    return false;
                }
                boolean bl = canCast = (double)totalCost <= manaCap.getCurrentMana() || manaCap.getCurrentMana() == (double)manaCap.getMaxMana() || entity instanceof Player && (player = (Player)entity).isCreative();
                if (!(canCast || entity.getCommandSenderWorld().isClientSide || this.silent)) {
                    PortUtil.sendMessageNoSpam((Entity)entity, (Component)Component.translatable((String)"ars_nouveau.spell.no_mana"));
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        Networking.sendToPlayerClient(new NotEnoughManaPacket(totalCost), serverPlayer);
                    }
                }
                return canCast;
            }
        };
    }

    @Override
    public DataComponentType<TomeCasterData> getComponentType() {
        return (DataComponentType)DataComponentRegistry.TOME_CASTER.get();
    }

    @Override
    protected TomeCasterData build(int slot, String flavorText, Boolean isHidden, String hiddenText, int maxSlots, SpellSlotMap spells) {
        return new TomeCasterData((Integer)slot, flavorText, isHidden, hiddenText, maxSlots, spells);
    }
}

