/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.hollingsworth.arsnouveau.api.potion.IPotionProvider;
import com.hollingsworth.arsnouveau.api.registry.PotionProviderRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;

public record PotionLauncherData(PotionContents renderData, int amountLeft, int lastSlot) {
    public static MapCodec<PotionLauncherData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PotionContents.CODEC.fieldOf("lastDataForRender").forGetter(PotionLauncherData::renderData), (App)Codec.INT.fieldOf("amountLeft").forGetter(PotionLauncherData::amountLeft), (App)Codec.INT.fieldOf("lastSlot").forGetter(PotionLauncherData::lastSlot)).apply((Applicative)instance, PotionLauncherData::new));
    public static StreamCodec<RegistryFriendlyByteBuf, PotionLauncherData> STREAM = StreamCodec.composite((StreamCodec)PotionContents.STREAM_CODEC, PotionLauncherData::renderData, (StreamCodec)ByteBufCodecs.INT, PotionLauncherData::amountLeft, (StreamCodec)ByteBufCodecs.INT, PotionLauncherData::lastSlot, PotionLauncherData::new);

    public PotionLauncherData() {
        this(PotionContents.EMPTY, 0, -1);
    }

    public PotionContents getPotionDataFromSlot(Player player) {
        if (this.lastSlot < 0 || this.lastSlot >= player.inventory.getContainerSize()) {
            return PotionContents.EMPTY;
        }
        ItemStack stack = player.inventory.getItem(this.lastSlot);
        IPotionProvider provider = PotionProviderRegistry.from(stack);
        return provider == null ? PotionContents.EMPTY : provider.getPotionData(stack);
    }

    public PotionContents expendPotion(Player player, ItemStack launcherStack) {
        if (this.lastSlot >= player.inventory.getContainerSize()) {
            return PotionContents.EMPTY;
        }
        ItemStack item = player.inventory.getItem(this.lastSlot);
        IPotionProvider provider = PotionProviderRegistry.from(item);
        if (provider == null) {
            return PotionContents.EMPTY;
        }
        if (provider.usesRemaining(item) <= 0) {
            return PotionContents.EMPTY;
        }
        PotionContents contents = provider.getPotionData(item);
        provider.consumeUses(item, 1, (LivingEntity)player);
        launcherStack.set(DataComponentRegistry.POTION_LAUNCHER, (Object)new PotionLauncherData(provider.getPotionData(item), provider.usesRemaining(item), this.lastSlot));
        return contents;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PotionLauncherData that = (PotionLauncherData)o;
        return this.lastSlot == that.lastSlot && this.amountLeft == that.amountLeft && Objects.equals(this.renderData, that.renderData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.renderData, this.amountLeft, this.lastSlot);
    }
}

