/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.hollingsworth.arsnouveau.api.item.NBTComponent;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public class PersistentFamiliarData
implements NBTComponent<PersistentFamiliarData>,
TooltipProvider {
    public static MapCodec<PersistentFamiliarData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ComponentSerialization.CODEC.optionalFieldOf("name", (Object)CommonComponents.EMPTY).forGetter(data -> data.name), (App)Codec.STRING.optionalFieldOf("color", (Object)"").forGetter(data -> data.color), (App)ItemStack.CODEC.optionalFieldOf("cosmetic", (Object)ItemStack.EMPTY).forGetter(data -> data.cosmetic)).apply((Applicative)instance, PersistentFamiliarData::new));
    public static StreamCodec<RegistryFriendlyByteBuf, PersistentFamiliarData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC, s -> s.name, (StreamCodec)ByteBufCodecs.STRING_UTF8, s -> s.color, (StreamCodec)ItemStack.STREAM_CODEC, s -> s.cosmetic, PersistentFamiliarData::new);
    private final Component name;
    private final String color;
    private final ItemStack cosmetic;

    public PersistentFamiliarData(Component name, String color, ItemStack cosmetic) {
        this.name = name == null ? CommonComponents.EMPTY : name;
        this.color = color == null ? "" : color;
        this.cosmetic = cosmetic == null ? ItemStack.EMPTY : cosmetic;
    }

    public PersistentFamiliarData() {
        this(Component.nullToEmpty((String)""), "", ItemStack.EMPTY);
    }

    public PersistentFamiliarData setName(Component name) {
        return new PersistentFamiliarData(name, this.color, this.cosmetic);
    }

    public PersistentFamiliarData setColor(String color) {
        return new PersistentFamiliarData(this.name, color, this.cosmetic);
    }

    public PersistentFamiliarData setCosmetic(ItemStack cosmetic) {
        return new PersistentFamiliarData(this.name, this.color, cosmetic);
    }

    public static PersistentFamiliarData fromTag(Tag tag) {
        return (PersistentFamiliarData)CODEC.codec().parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow();
    }

    @Override
    public Codec<PersistentFamiliarData> getCodec() {
        return CODEC.codec();
    }

    public void addToTooltip(Item.TooltipContext pContext, Consumer<Component> pTooltipAdder, TooltipFlag pTooltipFlag) {
        if (this.name != null) {
            pTooltipAdder.accept(this.name);
        }
    }

    public Mutable mutable() {
        return new Mutable(this.name, this.color, this.cosmetic);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentFamiliarData that = (PersistentFamiliarData)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.color, that.color) && Objects.equals(this.cosmetic, that.cosmetic);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.color, this.cosmetic);
    }

    public Component name() {
        return this.name == CommonComponents.EMPTY ? null : this.name;
    }

    public String color() {
        return this.color.isEmpty() ? null : this.color;
    }

    public ItemStack cosmetic() {
        return this.cosmetic;
    }

    public static class Mutable {
        public Component name;
        public String color;
        public ItemStack cosmetic;

        public Mutable(Component name, String color, ItemStack cosmetic) {
            this.name = name;
            this.color = color;
            this.cosmetic = cosmetic;
        }

        public PersistentFamiliarData toImmutable() {
            return new PersistentFamiliarData(this.name, this.color, this.cosmetic);
        }
    }
}

