/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record CodexData(Optional<UUID> uuid, String playerName, List<ResourceLocation> glyphIds) implements TooltipProvider
{
    public static Codec<CodexData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.optionalFieldOf("uuid").forGetter(CodexData::uuid), (App)Codec.STRING.optionalFieldOf("playerName", (Object)"").forGetter(CodexData::playerName), (App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("glyphIds").forGetter(CodexData::glyphIds)).apply((Applicative)instance, CodexData::new));
    public static StreamCodec<RegistryFriendlyByteBuf, CodexData> STREAM = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs::optional), CodexData::uuid, (StreamCodec)ByteBufCodecs.STRING_UTF8, CodexData::playerName, (StreamCodec)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)), CodexData::glyphIds, CodexData::new);

    public CodexData(UUID uuid, String playerName, List<ResourceLocation> glyphIds) {
        this(Optional.of(uuid), playerName, glyphIds);
    }

    public boolean wasRecorded() {
        return this.uuid.isPresent() && this.playerName != null && !this.playerName.isEmpty() && !this.uuid.get().equals(UUID.fromString(""));
    }

    public void addToTooltip(Item.TooltipContext pContext, Consumer<Component> pTooltipAdder, TooltipFlag pTooltipFlag) {
        if (this.glyphIds().isEmpty()) {
            pTooltipAdder.accept((Component)Component.translatable((String)"ars_nouveau.codex_tooltip"));
        } else {
            pTooltipAdder.accept((Component)Component.translatable((String)"ars_nouveau.contains_glyphs", (Object[])new Object[]{this.glyphIds().size()}));
        }
        if (this.wasRecorded()) {
            pTooltipAdder.accept((Component)Component.translatable((String)"ars_nouveau.recorded_by", (Object[])new Object[]{this.playerName()}));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodexData codexData = (CodexData)o;
        return Objects.equals(this.playerName, codexData.playerName) && Objects.equals(this.uuid, codexData.uuid) && Objects.equals(this.glyphIds, codexData.glyphIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.uuid, this.playerName, this.glyphIds);
    }
}

