/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.ItemScrollData;
import com.hollingsworth.arsnouveau.common.items.data.VoidJarData;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VoidJar
extends ModItem
implements IScribeable {
    public VoidJar() {
        super(ItemsRegistry.defaultItemProperties().stacksTo(1).component(DataComponentRegistry.VOID_JAR, (Object)new VoidJarData()));
    }

    public void toggleStatus(Player playerEntity, ItemStack stack) {
        VoidJarData jarData;
        VoidJarData newData = (VoidJarData)stack.set(DataComponentRegistry.VOID_JAR, (Object)jarData.setActive(!(jarData = (VoidJarData)stack.getOrDefault(DataComponentRegistry.VOID_JAR, (Object)new VoidJarData())).active()));
        if (newData.active()) {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.on"));
        } else {
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.off"));
        }
    }

    public static boolean tryVoiding(Player player, ItemStack pickingUp) {
        NonNullList list = player.inventory.items;
        for (ItemStack jar : list) {
            Item item = jar.getItem();
            if (!(item instanceof VoidJar)) continue;
            VoidJar voidJar = (VoidJar)item;
            return voidJar.voidStack(player, jar, pickingUp);
        }
        Item item = player.getOffhandItem().getItem();
        if (item instanceof VoidJar) {
            VoidJar voidJar = (VoidJar)item;
            return voidJar.voidStack(player, player.getOffhandItem(), pickingUp);
        }
        return false;
    }

    public boolean voidStack(Player player, ItemStack jarStack, ItemStack stackToVoid) {
        VoidJarData jarData = (VoidJarData)jarStack.getOrDefault(DataComponentRegistry.VOID_JAR, (Object)new VoidJarData());
        if (jarData.active() && jarData.scrollData().containsStack(stackToVoid)) {
            int amount = stackToVoid.getCount();
            this.preConsume(player, jarStack, stackToVoid, amount);
            stackToVoid.setCount(0);
            return true;
        }
        return false;
    }

    public void preConsume(Player player, ItemStack jar, ItemStack voided, int amount) {
        ManaCap mana = CapabilityRegistry.getMana((LivingEntity)player);
        if (mana == null) {
            return;
        }
        mana.removeMana(5.0 * (double)amount);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand handIn) {
        if (worldIn.isClientSide) {
            return super.use(worldIn, player, handIn);
        }
        ItemStack stack = player.getItemInHand(handIn);
        VoidJarData data = (VoidJarData)stack.getOrDefault(DataComponentRegistry.VOID_JAR, (Object)new VoidJarData());
        if (handIn == InteractionHand.MAIN_HAND) {
            ItemStack stackToWrite = player.getOffhandItem();
            if (player.isShiftKeyDown()) {
                this.toggleStatus(player, stack);
                return InteractionResultHolder.consume((Object)stack);
            }
            ItemScrollData.Mutable items = data.scrollData().mutable();
            items.writeWithFeedback(player, stackToWrite);
            stack.set(DataComponentRegistry.VOID_JAR, (Object)new VoidJarData(items.toImmutable(), data.active()));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    @Override
    public boolean onScribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack thisStack) {
        VoidJarData data = (VoidJarData)thisStack.getOrDefault(DataComponentRegistry.VOID_JAR, (Object)new VoidJarData());
        ItemScrollData.Mutable items = data.scrollData().mutable();
        boolean written = items.writeWithFeedback(player, player.getItemInHand(handIn));
        thisStack.set(DataComponentRegistry.VOID_JAR, (Object)new VoidJarData(items.toImmutable(), data.active()));
        return written;
    }
}

