/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RitualTablet
extends ModItem {
    public AbstractRitual ritual;

    public RitualTablet(Item.Properties properties) {
        super(properties);
    }

    public RitualTablet(AbstractRitual ritual) {
        super(ItemsRegistry.defaultItemProperties());
        this.ritual = ritual;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        if (!context.getLevel().isClientSide() && (blockEntity = context.getLevel().getBlockEntity(context.getClickedPos())) instanceof RitualBrazierTile) {
            RitualBrazierTile tile = (RitualBrazierTile)blockEntity;
            if (!tile.canTakeAnotherRitual()) {
                context.getPlayer().sendSystemMessage((Component)Component.translatable((String)"ars_nouveau.ritual.no_start"));
                return InteractionResult.PASS;
            }
            tile.setRitual(this.ritual.getRegistryName());
            if (!context.getPlayer().isCreative()) {
                context.getItemInHand().shrink(1);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip2, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip2, flagIn);
        tooltip2.add((Component)Component.translatable((String)"tooltip.ars_nouveau.tablet"));
        if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)Minecraft.getInstance().options.keyShift.getKey().getValue())) {
            tooltip2.add((Component)Component.translatable((String)this.ritual.getDescriptionKey()));
        } else {
            tooltip2.add((Component)Component.translatable((String)"tooltip.ars_nouveau.hold_shift", (Object[])new Object[]{Minecraft.getInstance().options.keyShift.getKey().getDisplayName()}).withStyle(Style.EMPTY.withColor(ChatFormatting.BLUE)));
        }
    }

    public Component getName(ItemStack pStack) {
        return Component.literal((String)this.ritual.getName());
    }
}

