/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.LightBlock;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.LightJarData;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class JarOfLight
extends ModItem {
    public JarOfLight() {
        super(ItemsRegistry.defaultItemProperties().component(DataComponentRegistry.LIGHT_JAR, (Object)new LightJarData(null, false)));
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        if (worldIn.isClientSide) {
            return;
        }
        LightJarData data = (LightJarData)stack.getOrDefault(DataComponentRegistry.LIGHT_JAR, (Object)new LightJarData(null, false));
        if (!data.enabled()) {
            return;
        }
        BlockPos lightLocation = data.pos();
        BlockState state = worldIn.getBlockState(lightLocation);
        if (!(state.getBlock() instanceof LightBlock)) {
            stack.set(DataComponentRegistry.LIGHT_JAR, (Object)new LightJarData(null, true));
        }
        if (BlockUtil.distanceFrom(lightLocation, entityIn.blockPosition()) > 7.0) {
            Direction opposite = entityIn.getDirection().getOpposite();
            BlockPos preferredLightPos = entityIn.blockPosition().relative(opposite, 1);
            if (worldIn.getBlockState(lightLocation).getBlock() instanceof LightBlock) {
                worldIn.setBlockAndUpdate(lightLocation, Blocks.AIR.defaultBlockState());
            }
            if (!this.placeLight(worldIn, preferredLightPos)) {
                this.placeLight(worldIn, preferredLightPos.above(2));
                stack.set(DataComponentRegistry.LIGHT_JAR, (Object)new LightJarData(preferredLightPos.above(2), true));
            } else {
                stack.set(DataComponentRegistry.LIGHT_JAR, (Object)new LightJarData(preferredLightPos, true));
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        if (worldIn.isClientSide) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        LightJarData tag = (LightJarData)itemstack.getOrDefault(DataComponentRegistry.LIGHT_JAR, (Object)new LightJarData(null, false));
        if (tag.pos() != null) {
            this.removeLight(worldIn, tag);
            itemstack.set(DataComponentRegistry.LIGHT_JAR, (Object)new LightJarData(null, false));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
        }
        this.placeLight(worldIn, playerIn.blockPosition());
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public boolean placeLight(Level world, BlockPos pos) {
        if (world.getBlockState(pos).isAir()) {
            world.setBlockAndUpdate(pos, ((LightBlock)BlockRegistry.LIGHT_BLOCK.get()).defaultBlockState());
            return true;
        }
        return false;
    }

    public void removeLight(Level world, LightJarData lightJarData) {
        BlockPos pos = lightJarData.pos();
        if (pos == null) {
            return;
        }
        if (world.getBlockState(pos).getBlock() instanceof LightBlock) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        }
    }
}

