/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class FamiliarScript
extends ModItem {
    public AbstractFamiliarHolder familiar;

    public FamiliarScript(AbstractFamiliarHolder familiar) {
        this.familiar = familiar;
    }

    public FamiliarScript(Item.Properties properties) {
        super(properties);
    }

    public FamiliarScript() {
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn.isClientSide || handIn != InteractionHand.MAIN_HAND) {
            return super.use(worldIn, playerIn, handIn);
        }
        ANPlayerDataCap familiarCap = CapabilityRegistry.getPlayerDataCap((LivingEntity)playerIn);
        if (familiarCap != null) {
            if (familiarCap.ownsFamiliar(this.familiar)) {
                playerIn.sendSystemMessage((Component)Component.translatable((String)"ars_nouveau.familiar.owned"));
                return super.use(worldIn, playerIn, handIn);
            }
            familiarCap.unlockFamiliar(this.familiar);
            CapabilityRegistry.EventHandler.syncPlayerCap(playerIn);
            playerIn.sendSystemMessage((Component)Component.translatable((String)"ars_nouveau.familiar.unlocked"));
            playerIn.getItemInHand(handIn).shrink(1);
        }
        return super.use(worldIn, playerIn, handIn);
    }

    public Component getName(ItemStack pStack) {
        return Component.translatable((String)"ars_nouveau.bound_script", (Object[])new Object[]{this.familiar.getLangName().getString()});
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip2, TooltipFlag flagIn) {
        tooltip2.add((Component)Component.translatable((String)"ars_nouveau.familiar.script"));
    }
}

