/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.DominionWandData;
import com.hollingsworth.arsnouveau.common.network.HighlightAreaPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DominionWand
extends ModItem {
    public DominionWand() {
        super(ItemsRegistry.defaultItemProperties().stacksTo(1).component(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData()));
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (!pIsSelected || pLevel.isClientSide || pLevel.getGameTime() % 5L != 0L) {
            return;
        }
        DominionWandData data = (DominionWandData)pStack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (data.storedPos().isPresent()) {
            BlockEntity blockEntity = pLevel.getBlockEntity(data.storedPos().get());
            if (blockEntity instanceof IWandable) {
                IWandable wandable = (IWandable)blockEntity;
                Networking.sendToPlayerClient(new HighlightAreaPacket(wandable.getWandHighlight(new ArrayList<ColorPos>()), 10), (ServerPlayer)pEntity);
            }
            return;
        }
        Entity entity = pLevel.getEntity(data.getStoredEntity());
        if (entity instanceof IWandable) {
            IWandable wandable = (IWandable)entity;
            Networking.sendToPlayerClient(new HighlightAreaPacket(wandable.getWandHighlight(new ArrayList<ColorPos>()), 10), (ServerPlayer)pEntity);
        }
    }

    public InteractionResult interactLivingEntity(ItemStack doNotUseStack, Player playerEntity, LivingEntity target, InteractionHand hand) {
        IWandable wandable;
        BlockEntity blockEntity;
        if (playerEntity.level.isClientSide || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = playerEntity.getItemInHand(hand);
        DominionWandData data = (DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (playerEntity.isShiftKeyDown() && target instanceof IWandable) {
            IWandable wandable2 = (IWandable)target;
            wandable2.onWanded(playerEntity);
            this.clear(stack, playerEntity);
            return InteractionResult.SUCCESS;
        }
        if (!data.hasStoredData()) {
            stack.set(DataComponentRegistry.DOMINION_WAND, (Object)data.storeEntity(target.getId()));
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.dominion_wand.stored_entity"));
            return InteractionResult.SUCCESS;
        }
        Level world = playerEntity.getCommandSenderWorld();
        if (data.storedPos().isPresent() && (blockEntity = world.getBlockEntity(data.storedPos().get())) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            wandable.onFinishedConnectionFirst(data.storedPos().orElse(null), data.face().orElse(null), target, playerEntity);
        }
        if (target instanceof IWandable) {
            wandable = (IWandable)target;
            wandable.onFinishedConnectionLast(data.storedPos().orElse(null), data.face().orElse(null), target, playerEntity);
            this.clear(stack, playerEntity);
        }
        if (playerEntity.isShiftKeyDown() && target instanceof IDecoratable) {
            IDecoratable coolBoy = (IDecoratable)target;
            coolBoy.setCosmeticItem(ItemStack.EMPTY);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return false;
    }

    public void clear(ItemStack stack, Player player) {
        DominionWandData data = ((DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData())).setFace(null).storeEntity(-1).storePos(null);
        stack.set(DataComponentRegistry.DOMINION_WAND, (Object)data);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        DominionWandData data = (DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (pPlayer.isShiftKeyDown() && !data.hasStoredData()) {
            data = data.toggleMode();
            stack.set(DataComponentRegistry.DOMINION_WAND, (Object)data);
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public InteractionResult useOn(UseOnContext context) {
        IWandable wandable;
        BlockEntity blockEntity;
        BlockEntity blockEntity2;
        if (context.getLevel().isClientSide || context.getPlayer() == null) {
            return super.useOn(context);
        }
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        Player playerEntity = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        DominionWandData data = (DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (playerEntity.isShiftKeyDown() && (blockEntity2 = world.getBlockEntity(pos)) instanceof IWandable) {
            IWandable wandable2 = (IWandable)blockEntity2;
            if (!data.hasStoredData()) {
                wandable2.onWanded(playerEntity);
                this.clear(stack, playerEntity);
                return InteractionResult.CONSUME;
            }
        }
        if (!data.hasStoredData()) {
            stack.set(DataComponentRegistry.DOMINION_WAND, (Object)data.storePos(pos.immutable()));
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.dominion_wand.position_set"));
            return InteractionResult.SUCCESS;
        }
        if (data.face().isEmpty() && data.strict()) {
            stack.set(DataComponentRegistry.DOMINION_WAND, (Object)data.setFace(context.getClickedFace()));
        }
        BlockPos storedPos = data.storedPos().orElse(null);
        Direction storedDirection = data.face().orElse(null);
        if (storedPos != null && (blockEntity = world.getBlockEntity(storedPos)) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            wandable.onFinishedConnectionFirst(pos, storedDirection, (LivingEntity)world.getEntity(data.storedEntityId()), playerEntity);
        }
        if ((blockEntity = world.getBlockEntity(pos)) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            wandable.onFinishedConnectionLast(storedPos, storedDirection, (LivingEntity)world.getEntity(data.storedEntityId()), playerEntity);
        }
        if (data.storedEntityId() != -1 && (blockEntity = world.getEntity(data.storedEntityId())) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            wandable.onFinishedConnectionFirst(pos, storedDirection, null, playerEntity);
        }
        this.clear(stack, playerEntity);
        return super.useOn(context);
    }

    public String getDescriptionId(ItemStack pStack) {
        DominionWandData data = (DominionWandData)pStack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (data.strict()) {
            return super.getDescriptionId(pStack) + ".strict";
        }
        return super.getDescriptionId(pStack);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext world, List<Component> tooltip, TooltipFlag p_77624_4_) {
        DominionWandData data = (DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (data.storedEntityId() == -1) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.dominion_wand.no_entity"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.dominion_wand.entity_stored"));
        }
        if (data.storedPos().isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.dominion_wand.no_location"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.dominion_wand.position_stored", (Object[])new Object[]{DominionWand.getPosString(data.getValidPos())}));
        }
        if (data.strict()) {
            tooltip.add((Component)Component.literal((String)"Side-Sensitive"));
        }
    }

    public static String getPosString(BlockPos pos) {
        return Component.translatable((String)"ars_nouveau.position", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).getString();
    }
}

