/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.IRadialProvider;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenuSlot;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.client.registry.ModKeyBindings;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketConsumePotion;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.common.util.PotionUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AlchemistsCrown
extends ModItem
implements IRadialProvider {
    public AlchemistsCrown(Item.Properties properties) {
        super(properties);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip2, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip2, flagIn);
        tooltip2.add((Component)Component.translatable((String)"ars_nouveau.tooltip.alchemists_crown", (Object[])new Object[]{KeyMapping.createNameSupplier((String)ModKeyBindings.HEAD_CURIO_HOTKEY.getName()).get()}));
    }

    @Override
    public int forKey() {
        return ModKeyBindings.HEAD_CURIO_HOTKEY.getKey().getValue();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRadialKeyPressed(ItemStack stack, Player player) {
        ArrayList slots = new ArrayList();
        for (int i = 0; i < player.inventory.getContainerSize() && slots.size() < 9; ++i) {
            ItemStack item = player.inventory.getItem(i);
            PotionContents contents = PotionUtil.getContents(item);
            if (contents == PotionContents.EMPTY || item.getItem() instanceof ArrowItem) continue;
            slots.add(new RadialMenuSlot<SlotData>(item.getHoverName().getString(), new SlotData(i, item)));
        }
        if (slots.isEmpty()) {
            PortUtil.sendMessage((Entity)Minecraft.getInstance().player, (Component)Component.translatable((String)"ars_nouveau.alchemists_crown.no_flasks"));
            return;
        }
        Minecraft.getInstance().setScreen(new GuiRadialMenu<SlotData>(new RadialMenu<SlotData>(index -> Networking.sendToServer(new PacketConsumePotion(((SlotData)((RadialMenuSlot)slots.get((int)index)).primarySlotIcon()).slot)), slots, (slotData, posestack, positionx, posy, size, transparent) -> RenderUtils.drawItemAsIcon(slotData.stack, posestack, positionx, posy, size, transparent), 3)));
    }

    public record SlotData(int slot, ItemStack stack) {
        public int getSlot() {
            return this.slot;
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

