/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.event;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.event.DispelEvent;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.loot.DungeonLootTables;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.recipe.MultiRecipeWrapper;
import com.hollingsworth.arsnouveau.api.registry.BuddingConversionRegistry;
import com.hollingsworth.arsnouveau.api.registry.CasterTomeRegistry;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.api.registry.ScryRitualRegistry;
import com.hollingsworth.arsnouveau.api.ritual.RitualEventQueue;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.api.util.CuriosUtil;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.command.AddTomeCommand;
import com.hollingsworth.arsnouveau.common.command.DataDumpCommand;
import com.hollingsworth.arsnouveau.common.command.LearnGlyphCommand;
import com.hollingsworth.arsnouveau.common.command.ResetCommand;
import com.hollingsworth.arsnouveau.common.command.SummonAnimHeadCommand;
import com.hollingsworth.arsnouveau.common.command.ToggleLightCommand;
import com.hollingsworth.arsnouveau.common.compat.CaelusHandler;
import com.hollingsworth.arsnouveau.common.crafting.recipes.DispelEntityRecipe;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.common.entity.Whirlisprig;
import com.hollingsworth.arsnouveau.common.entity.debug.FixedStack;
import com.hollingsworth.arsnouveau.common.items.EnchantersSword;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.items.VoidJar;
import com.hollingsworth.arsnouveau.common.lib.PotionEffectTags;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketJoinedServer;
import com.hollingsworth.arsnouveau.common.network.PotionSyncPacket;
import com.hollingsworth.arsnouveau.common.perk.JumpHeightPerk;
import com.hollingsworth.arsnouveau.common.ritual.DenySpawnRitual;
import com.hollingsworth.arsnouveau.common.ritual.RitualFlight;
import com.hollingsworth.arsnouveau.common.ritual.RitualGravity;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectGlide;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectWololo;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.hollingsworth.arsnouveau.setup.registry.VillagerRegistry;
import com.hollingsworth.arsnouveau.setup.reward.Rewards;
import com.mojang.brigadier.CommandDispatcher;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@EventBusSubscriber(modid="ars_nouveau")
public class EventHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void resourceLoadEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Object>(){

            protected Object prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                return null;
            }

            protected void apply(Object pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                MultiRecipeWrapper.RECIPE_CACHE = new HashMap<Item, MultiRecipeWrapper>();
                EffectWololo.recipeCache = new FixedStack(EffectWololo.MAX_RECIPE_CACHE);
                ArsNouveauAPI.getInstance().onResourceReload();
                EventQueue.getServerInstance().addEvent(new ITimedEvent(this){
                    boolean expired;

                    @Override
                    public void tick(ServerTickEvent serverTickEvent) {
                        CasterTomeRegistry.reloadTomeData(serverTickEvent.getServer().getRecipeManager(), (Level)serverTickEvent.getServer().getLevel(Level.OVERWORLD));
                        BuddingConversionRegistry.reloadBuddingConversionRecipes(serverTickEvent.getServer().getRecipeManager());
                        ScryRitualRegistry.reloadScryRitualRecipes(serverTickEvent.getServer().getRecipeManager());
                        this.expired = true;
                    }

                    @Override
                    public void tick(boolean serverSide) {
                    }

                    @Override
                    public boolean isExpired() {
                        return this.expired;
                    }
                });
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void itemPickupEvent(ItemEntityPickupEvent.Pre event) {
        Player player = event.getPlayer();
        ItemStack pickingUp = event.getItemEntity().getItem();
        VoidJar.tryVoiding(player, pickingUp);
    }

    @SubscribeEvent
    public static void shieldEvent(LivingShieldBlockEvent e) {
        Player player;
        LivingEntity livingEntity;
        if (!e.getEntity().level.isClientSide && (livingEntity = e.getEntity()) instanceof Player && (player = (Player)livingEntity).isBlocking() && player.getUseItem().getItem() == ItemsRegistry.ENCHANTERS_SHIELD.asItem()) {
            player.addEffect(new MobEffectInstance(ModPotions.MANA_REGEN_EFFECT, 200, 1));
            player.addEffect(new MobEffectInstance(ModPotions.SPELL_DAMAGE_EFFECT, 200, 1));
        }
    }

    @SubscribeEvent
    public static void livingHurtEvent(LivingDamageEvent.Post e) {
        if (e.getEntity().level.isClientSide) {
            return;
        }
        Entity entity = e.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingUser = (LivingEntity)entity;
            if (livingUser instanceof Player) {
                return;
            }
            if (livingUser.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof EnchantersSword && BlockUtil.distanceFrom(livingUser.position, e.getEntity().position) < 3.0) {
                livingUser.getItemInHand(InteractionHand.MAIN_HAND).getItem().hurtEnemy(livingUser.getMainHandItem(), e.getEntity(), livingUser);
            }
        }
    }

    @SubscribeEvent
    public static void livingSpawnEvent(FinalizeSpawnEvent checkSpawn) {
        ServerLevelAccessor serverLevelAccessor = checkSpawn.getLevel();
        if (serverLevelAccessor instanceof Level) {
            Level level = (Level)serverLevelAccessor;
            if (!level.isClientSide) {
                RitualEventQueue.getRitual(level, DenySpawnRitual.class, ritu -> ritu.denySpawn(checkSpawn));
            }
        }
    }

    @SubscribeEvent
    public static void jumpEvent(LivingEvent.LivingJumpEvent e) {
        if (e.getEntity() != null && e.getEntity().hasEffect(ModPotions.SNARE_EFFECT)) {
            e.getEntity().setDeltaMovement(0.0, 0.0, 0.0);
            return;
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        String book_tag;
        CompoundTag tag;
        ServerPlayer serverPlayer;
        boolean isContributor;
        if (e.getEntity().getCommandSenderWorld().isClientSide) {
            return;
        }
        Player player = e.getEntity();
        if (player instanceof ServerPlayer && (isContributor = Rewards.CONTRIBUTORS.contains((serverPlayer = (ServerPlayer)player).getUUID()))) {
            Networking.sendToPlayerClient(new PacketJoinedServer(true), (ServerPlayer)e.getEntity());
        }
        if (!(tag = e.getEntity().getPersistentData().getCompound("PlayerPersisted")).getBoolean(book_tag = "an_book_") && ((Boolean)Config.SPAWN_BOOK.get()).booleanValue()) {
            Player entity = e.getEntity();
            ItemHandlerHelper.giveItemToPlayer((Player)entity, (ItemStack)new ItemStack(ItemsRegistry.WORN_NOTEBOOK));
            tag.putBoolean(book_tag, true);
            e.getEntity().getPersistentData().put("PlayerPersisted", (Tag)tag);
        }
    }

    @SubscribeEvent
    public static void clientTickEnd(ClientTickEvent.Post event) {
        ++ClientInfo.ticksInGame;
        if (ClientInfo.redTicks()) {
            --ClientInfo.redOverlayTicks;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGlideTick(PlayerTickEvent.Pre event) {
        ServerPlayer serverPlayer;
        Player player = event.getEntity();
        if (ArsNouveau.caelusLoaded && EffectGlide.canGlide((LivingEntity)player)) {
            CaelusHandler.setFlying(player);
        }
        if (player.hasEffect(ModPotions.FLIGHT_EFFECT) && player.level.getGameTime() % 20L == 0L && player.getEffect(ModPotions.FLIGHT_EFFECT).getDuration() <= 600 && player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            RitualEventQueue.getRitual(player.level, RitualFlight.class, flight -> flight.attemptRefresh(serverPlayer));
        }
        if (player.level.getGameTime() % (long)RitualGravity.renewInterval == 0L && player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            MobEffectInstance gravity = player.getEffect(ModPotions.GRAVITY_EFFECT);
            if (gravity == null || gravity.getDuration() <= RitualGravity.renewThreshold) {
                RitualEventQueue.getRitual(player.level, RitualGravity.class, ritual -> !serverPlayer.isCreative() && ritual.attemptRefresh(serverPlayer));
            }
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity livingEntity;
        if (!event.getEntity().level.isClientSide && (livingEntity = event.getEntity()) instanceof Player) {
            Player entity = (Player)livingEntity;
            RitualEventQueue.getRitual(entity.level, RitualFlight.class, flight -> flight.onJumpEvent(event));
        }
    }

    @SubscribeEvent
    public static void entityHurt(LivingDamageEvent.Pre e) {
        LivingEntity entity;
        DamageContainer container = e.getContainer();
        DamageSource source = container.getSource();
        float amount = container.getNewDamage();
        if (e.getEntity().hasEffect(ModPotions.DEFENCE_EFFECT) && (source.is(DamageTypes.MAGIC) || source.is(DamageTypes.GENERIC) || source.is(DamageTypes.MOB_ATTACK)) && (double)amount > 0.5) {
            container.setNewDamage((float)Math.max(0.5, (double)(amount - 1.0f - (float)e.getEntity().getEffect(ModPotions.DEFENCE_EFFECT).getAmplifier())));
        }
        if (source.is(DamageTypes.LIGHTNING_BOLT) && e.getEntity().hasEffect(ModPotions.SHOCKED_EFFECT)) {
            float damage = amount + 3.0f + 3.0f * (float)e.getEntity().getEffect(ModPotions.SHOCKED_EFFECT).getAmplifier();
            container.setNewDamage(Math.max(0.0f, damage));
        }
        if ((entity = e.getEntity()) == null) {
            return;
        }
        if (entity.hasEffect(ModPotions.HEX_EFFECT) && (entity.hasEffect(MobEffects.POISON) || entity.hasEffect(MobEffects.WITHER) || entity.isOnFire() || entity.hasEffect(ModPotions.SHOCKED_EFFECT) || entity.getTicksFrozen() >= entity.getTicksRequiredToFreeze())) {
            container.setNewDamage(amount + 0.5f + 0.33f * (float)entity.getEffect(ModPotions.HEX_EFFECT).getAmplifier());
        }
        double warding = PerkUtil.valueOrZero(entity, PerkAttributes.WARDING);
        double feather = PerkUtil.valueOrZero(entity, PerkAttributes.FEATHER);
        if (source.is(DamageTypes.MAGIC)) {
            container.setNewDamage((float)((double)amount - warding));
        }
        if (source.is(DamageTypes.FALL)) {
            container.setNewDamage((float)((double)amount - (double)amount * feather));
        }
    }

    @SubscribeEvent
    public static void fallEvent(LivingFallEvent fallEvent) {
        double jumpBonus = PerkUtil.countForPerk(JumpHeightPerk.INSTANCE, fallEvent.getEntity());
        fallEvent.setDistance((float)((double)fallEvent.getDistance() - jumpBonus / 0.1));
        if (CuriosUtil.hasItem(fallEvent.getEntity(), ItemsRegistry.BELT_OF_LEVITATION.asItem())) {
            fallEvent.setDistance(Math.max(0.0f, fallEvent.getDistance() - 6.0f));
        }
    }

    @SubscribeEvent
    public static void entityHeal(LivingHealEvent e) {
        LivingEntity entity = e.getEntity();
        if (entity != null && entity.hasEffect(ModPotions.HEX_EFFECT)) {
            e.setAmount(e.getAmount() / 2.0f);
        }
        if (entity != null && entity.hasEffect(ModPotions.RECOVERY_EFFECT)) {
            e.setAmount(e.getAmount() + 1.0f + (float)entity.getEffect(ModPotions.RECOVERY_EFFECT).getAmplifier());
        }
    }

    @SubscribeEvent
    public static void eatEvent(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity;
        if (!event.getEntity().level.isClientSide && event.getItem().getItem().getFoodProperties(event.getItem(), event.getEntity()) != null && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            FoodData stats = player.getFoodData();
            stats.saturationLevel = (float)((double)stats.saturationLevel * PerkUtil.perkValue((LivingEntity)player, PerkAttributes.WHIRLIESPRIG));
        }
    }

    private static void replaceEntityWithItems(ServerLevel level, Entity entity, ItemStack ... items) {
        entity.remove(Entity.RemovalReason.KILLED);
        ParticleUtil.spawnPoof(level, entity.blockPosition());
        for (ItemStack item : items) {
            level.addFreshEntity((Entity)new ItemEntity((Level)level, entity.getX(), entity.getY(), entity.getZ(), item));
        }
    }

    @SubscribeEvent
    public static void dispelEvent(DispelEvent event) {
        HitResult hitResult = event.rayTraceResult;
        if (hitResult instanceof EntityHitResult) {
            EntityHitResult hit = (EntityHitResult)hitResult;
            hitResult = event.world;
            if (hitResult instanceof ServerLevel) {
                Witch witch;
                ServerLevel level = (ServerLevel)hitResult;
                Entity entity = hit.getEntity();
                if (!entity.isAlive()) {
                    return;
                }
                if (entity instanceof Witch && (witch = (Witch)entity).getHealth() <= witch.getMaxHealth() / 2.0f) {
                    EventHandler.replaceEntityWithItems(level, (Entity)witch, new ItemStack(ItemsRegistry.WIXIE_SHARD));
                    return;
                }
                for (RecipeHolder holder : level.getRecipeManager().getAllRecipesFor((RecipeType)RecipeRegistry.DISPEL_ENTITY_TYPE.get())) {
                    DispelEntityRecipe recipe = (DispelEntityRecipe)holder.value();
                    if (!recipe.matches(event.shooter, entity)) continue;
                    EventHandler.replaceEntityWithItems(level, entity, (ItemStack[])recipe.result(event.shooter, entity).toArray(ItemStack[]::new));
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public static void commandRegister(RegisterCommandsEvent event) {
        ResetCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        DataDumpCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ToggleLightCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        AddTomeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SummonAnimHeadCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        LearnGlyphCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void registerTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerRegistry.SHARDS_TRADER.get()) {
            Int2ObjectMap trades = event.getTrades();
            List level1 = (List)trades.get(1);
            List level2 = (List)trades.get(2);
            List level3 = (List)trades.get(3);
            List level4 = (List)trades.get(4);
            List level5 = (List)trades.get(5);
            level1.add((trader, rand) -> EventHandler.itemToEmer(BlockRegistry.SOURCEBERRY_BUSH, 16, 16, 2));
            level1.add((trader, rand) -> EventHandler.itemToEmer(ItemsRegistry.MAGE_FIBER, 16, 16, 2));
            for (ItemStack fruit : Ingredient.of(ItemTagProvider.SHADY_WIZARD_FRUITS).getItems()) {
                level1.add((trader, rand) -> EventHandler.itemToEmer((ItemLike)fruit.getItem(), 6, 16, 2));
            }
            level1.add((trader, rand) -> EventHandler.itemToEmer((ItemLike)Items.AMETHYST_SHARD, 32, 16, 2));
            level1.add((trader, rand) -> EventHandler.emerToItem(ItemsRegistry.SOURCE_BERRY_ROLL, 4, 16, 2));
            level2.add((trader, rand) -> EventHandler.emerToItem(BlockRegistry.GHOST_WEAVE, 1, 8, 2));
            level2.add((trader, rand) -> EventHandler.emerToItem(BlockRegistry.MIRROR_WEAVE, 1, 8, 2));
            level2.add((trader, rand) -> EventHandler.emerToItem(BlockRegistry.FALSE_WEAVE, 1, 8, 2));
            level2.add((trader, rand) -> EventHandler.emerToItem(ItemsRegistry.WARP_SCROLL, 1, 8, 2));
            for (ItemStack wilden : Ingredient.of(ItemTagProvider.WILDEN_DROP_TAG).getItems()) {
                level2.add((trader, rand) -> EventHandler.itemToEmer((ItemLike)wilden.getItem(), 4, 8, 12));
            }
            ArrayList<RitualTablet> tablets = new ArrayList<RitualTablet>(RitualRegistry.getRitualItemMap().values());
            for (RitualTablet tablet : tablets) {
                if (new ItemStack((ItemLike)tablet).is(ItemTagProvider.RITUAL_TRADE_BLACKLIST) || !tablet.ritual.canBeTraded()) continue;
                level3.add((trader, rand) -> EventHandler.emerToItem((ItemLike)tablet, 4, 1, 12));
            }
            for (ItemStack shard : Ingredient.of(ItemTagProvider.SUMMON_SHARDS_TAG).getItems()) {
                level4.add((trader, rand) -> EventHandler.emerToItem((ItemLike)shard.getItem(), 20, 1, 20));
            }
            level5.add((trader, rand) -> EventHandler.emerToItem(ItemsRegistry.SOURCE_BERRY_PIE, 4, 8, 2));
            level5.add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 48), DungeonLootTables.getRandomItem(DungeonLootTables.RARE_LOOT), 1, 20, 0.2f));
        }
    }

    public static MerchantOffer emerToItem(ItemLike itemLike, int cost, int uses, int exp) {
        return new VillagerTrades.ItemsForEmeralds(itemLike.asItem(), cost, uses, exp).getOffer(null, null);
    }

    public static MerchantOffer itemToEmer(ItemLike itemLike, int cost, int uses, int exp) {
        return new VillagerTrades.EmeraldForItems((ItemLike)itemLike.asItem(), cost, uses, exp).getOffer(null, null);
    }

    @SubscribeEvent
    public static void onPotionAdd(MobEffectEvent.Added event) {
        LivingEntity target = event.getEntity();
        Entity applier = event.getEffectSource();
        if (target.level.isClientSide) {
            return;
        }
        double bonus = 0.0;
        Holder holder = event.getEffectInstance().getEffect();
        MobEffect effect = (MobEffect)holder.value();
        if (effect.isBeneficial()) {
            bonus = PerkUtil.valueOrZero(target, PerkAttributes.WIXIE);
        } else if (applier instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)applier;
            bonus = PerkUtil.valueOrZero(living, PerkAttributes.WIXIE);
        }
        if (bonus > 0.0) {
            event.getEffectInstance().duration = (int)((double)event.getEffectInstance().duration * bonus);
        }
        if (holder.is(PotionEffectTags.TO_SYNC)) {
            Networking.sendToNearbyClient(target.level(), (Entity)target, (CustomPacketPayload)new PotionSyncPacket(target.getId(), effect, event.getEffectInstance().getDuration()));
        }
    }

    @SubscribeEvent
    public static void onPotionRemove(MobEffectEvent.Remove event) {
        EventHandler.syncPotionRemoval((MobEffectEvent)event);
    }

    @SubscribeEvent
    public static void onPotionExpire(MobEffectEvent.Expired event) {
        EventHandler.syncPotionRemoval((MobEffectEvent)event);
    }

    private static void syncPotionRemoval(MobEffectEvent event) {
        if (event.getEntity() instanceof LivingEntity && event.getEffectInstance() != null && !event.getEntity().level.isClientSide) {
            LivingEntity target = event.getEntity();
            Holder holder = event.getEffectInstance().getEffect();
            MobEffect effect = (MobEffect)holder.value();
            if (holder.is(PotionEffectTags.TO_SYNC)) {
                Networking.sendToNearbyClient(target.level(), (Entity)target, (CustomPacketPayload)new PotionSyncPacket(target.getId(), effect, -1));
            }
        }
    }

    @SubscribeEvent
    public static void treeGrow(BlockGrowFeatureEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        Set<UUID> sprigs = Whirlisprig.WHIRLI_MAP.getEntities((Level)level);
        ArrayList<UUID> sprigsToRemove = new ArrayList<UUID>();
        for (UUID uuid : sprigs) {
            Entity entity = level.getEntity(uuid);
            if (entity instanceof Whirlisprig) {
                Whirlisprig whirlisprig = (Whirlisprig)entity;
                if (!(BlockUtil.distanceFrom(whirlisprig.blockPosition(), event.getPos()) <= 10.0) || whirlisprig.isTamed()) continue;
                whirlisprig.droppingShards = true;
                continue;
            }
            sprigsToRemove.add(uuid);
        }
        for (UUID uuid : sprigsToRemove) {
            Whirlisprig.WHIRLI_MAP.removeEntity((Level)level, uuid);
        }
    }

    private EventHandler() {
    }
}

