/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.wixie;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.event.FlyingItemEvent;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.StorageLecternTile;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import com.hollingsworth.arsnouveau.common.entity.EntityWixie;
import com.hollingsworth.arsnouveau.common.entity.goal.ExtendedRangeGoal;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketAnimEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class FindNextItemGoal
extends ExtendedRangeGoal {
    EntityWixie wixie;
    BlockPos movePos;
    ItemStack getStack;
    boolean found;

    public FindNextItemGoal(EntityWixie wixie) {
        super(10);
        this.wixie = wixie;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    @Override
    public void start() {
        super.start();
        this.movePos = null;
        Level world = this.wixie.getCommandSenderWorld();
        WixieCauldronTile tile = (WixieCauldronTile)world.getBlockEntity(this.wixie.cauldronPos);
        if (tile == null || tile.getInventories() == null) {
            this.found = true;
            return;
        }
        this.getStack = tile.craftManager.getNextItem();
        if (this.getStack.isEmpty()) {
            this.found = true;
            return;
        }
        HashSet<Item> itemSet = new HashSet<Item>();
        itemSet.add(this.getStack.getItem());
        for (BlockPos b : tile.getInventories()) {
            IItemHandler itemHandler;
            BlockEntity blockEntity = world.getBlockEntity(b);
            if (blockEntity == null || (itemHandler = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, b, null)) == null) continue;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.getItem() != this.getStack.getItem()) continue;
                this.movePos = b.immutable();
                this.startDistance = BlockUtil.distanceFrom(this.wixie.position, this.movePos);
                break;
            }
            if (this.movePos == null) continue;
            break;
        }
        this.found = false;
    }

    @Override
    public boolean canUse() {
        if (this.wixie.cauldronPos == null) {
            return false;
        }
        BlockEntity tileEntity = this.wixie.level.getBlockEntity(this.wixie.cauldronPos);
        if (!(tileEntity instanceof WixieCauldronTile)) {
            return false;
        }
        WixieCauldronTile cauldronTile = (WixieCauldronTile)tileEntity;
        boolean canStart = this.wixie.inventoryBackoff == 0 && cauldronTile.hasSource && !cauldronTile.isCraftingDone() && !cauldronTile.isOff && !cauldronTile.craftManager.getNextItem().isEmpty();
        return canStart;
    }

    public boolean canContinueToUse() {
        return !this.found;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.found && this.movePos != null && BlockUtil.distanceFrom(this.wixie.position(), this.movePos.above()) < 2.0 + this.extendedRange) {
            WixieCauldronTile tile = (WixieCauldronTile)this.wixie.getCommandSenderWorld().getBlockEntity(this.wixie.cauldronPos);
            Level world = this.wixie.getCommandSenderWorld();
            if (tile == null) {
                this.found = true;
                return;
            }
            ArrayList<ItemStack> neededStacks = new ArrayList<ItemStack>(tile.craftManager.neededItems);
            boolean anyFound = false;
            int spawnDelay = 0;
            ArrayList<StorageLecternTile.HandlerPos> handlers = new ArrayList<StorageLecternTile.HandlerPos>();
            for (BlockPos b : tile.getInventories()) {
                IItemHandler itemHandler;
                BlockEntity blockEntity = world.getBlockEntity(b);
                if (blockEntity == null || (itemHandler = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, b, null)) == null) continue;
                handlers.add(new StorageLecternTile.HandlerPos(b.immutable(), itemHandler));
            }
            for (ItemStack needed : neededStacks) {
                for (StorageLecternTile.HandlerPos handler : handlers) {
                    if (tile.craftManager.neededItems.isEmpty()) {
                        this.found = true;
                        return;
                    }
                    IItemHandler itemHandler = handler.handler();
                    for (int j = 0; j < itemHandler.getSlots(); ++j) {
                        ItemStack slotStack = itemHandler.getStackInSlot(j);
                        if (slotStack.getItem() != needed.getItem()) continue;
                        int size = slotStack.getCount();
                        int numNeeded = (int)tile.craftManager.neededItems.stream().filter(stack -> stack.getItem() == slotStack.getItem()).count();
                        int canExtract = Math.min(size, numNeeded);
                        for (int count = 0; count < canExtract; ++count) {
                            ItemStack stackToGive = itemHandler.extractItem(j, 1, false);
                            this.spawnFlyingItem(tile.getLevel(), tile.getBlockPos(), handler.pos(), stackToGive, 1 + 3 * spawnDelay++);
                            tile.giveItem(stackToGive);
                            if (anyFound) continue;
                            Networking.sendToNearbyClient(world, (Entity)this.wixie, (CustomPacketPayload)new PacketAnimEntity(this.wixie.getId(), EntityWixie.Animations.SUMMON_ITEM.ordinal()));
                            this.wixie.inventoryBackoff = 60;
                            anyFound = true;
                        }
                    }
                }
            }
            this.found = true;
            return;
        }
        if (this.movePos != null && !this.found) {
            this.setPath(this.movePos.getX(), this.movePos.getY() + 1, this.movePos.getZ(), 1.2);
        }
    }

    public void spawnFlyingItem(Level level, BlockPos worldPosition, BlockPos from, ItemStack stack, int delay) {
        BlockPos above = from.above();
        EntityFlyingItem flyingItem = new EntityFlyingItem(level, new Vec3((double)above.getX() + 0.5, (double)above.getY(), (double)above.getZ() + 0.5).add(ParticleUtil.inRange(-0.25, 0.25), 0.0, ParticleUtil.inRange(-0.25, 0.25)), new Vec3((double)worldPosition.getX() + 0.5, (double)worldPosition.getY(), (double)worldPosition.getZ() + 0.5).add(ParticleUtil.inRange(-0.25, 0.25), 0.0, ParticleUtil.inRange(-0.25, 0.25)));
        flyingItem.getEntityData().set(EntityFlyingItem.HELD_ITEM, (Object)stack.copy());
        EventQueue.getServerInstance().addEvent(new FlyingItemEvent(level, flyingItem, delay));
    }

    public void setPath(double x, double y, double z, double speedIn) {
        this.wixie.getNavigation().moveTo(this.wixie.getNavigation().createPath(x + 0.5, y + 0.5, z + 0.5, 0), speedIn);
    }
}

