/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.stalker;

import com.hollingsworth.arsnouveau.common.entity.WildenStalker;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class DiveAttackGoal
extends Goal {
    WildenStalker stalker;

    public DiveAttackGoal(WildenStalker stalker) {
        this.stalker = stalker;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.stalker.getTarget() != null && this.stalker.isFlying();
    }

    public boolean canContinueToUse() {
        LivingEntity livingentity = this.stalker.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.isAlive()) {
            return false;
        }
        if (!(livingentity instanceof Player) || !livingentity.isSpectator() && !((Player)livingentity).isCreative()) {
            return this.canUse();
        }
        return false;
    }

    public void start() {
    }

    public void tick() {
        LivingEntity livingentity = this.stalker.getTarget();
        this.stalker.orbitOffset = new Vec3(livingentity.getX(), livingentity.getY(0.5), livingentity.getZ());
        if (this.stalker.getBoundingBox().inflate((double)0.2f).intersects(livingentity.getBoundingBox())) {
            this.stalker.doHurtTarget((Entity)livingentity);
            this.stalker.setFlying(false);
        } else if (this.stalker.horizontalCollision || this.stalker.hurtTime > 0) {
            this.stalker.setFlying(false);
        }
    }
}

