/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.lily;

import com.hollingsworth.arsnouveau.common.entity.Lily;
import java.util.EnumSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class WagGoal
extends Goal {
    Lily lily;
    public LivingEntity target;
    public int wagAtTicks;

    public WagGoal(Lily lily) {
        this.lily = lily;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public void tick() {
        super.tick();
        if (this.wagAtTicks > 0) {
            --this.wagAtTicks;
        }
        if (this.target != null) {
            this.lily.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        }
    }

    public boolean canUse() {
        this.target = null;
        ServerLevel level = (ServerLevel)this.lily.level;
        for (Player player : level.getPlayers(p -> true)) {
            if (!(player.distanceTo((Entity)this.lily) < 5.0f) || !this.lily.isLookingAtMe(player)) continue;
            this.target = player;
            this.wagAtTicks = 100;
            this.lily.setWagging(true);
            this.lily.wagTicks = 100;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.wagAtTicks > 0;
    }
}

