/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.drygmy;

import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.block.tile.DrygmyTile;
import com.hollingsworth.arsnouveau.common.entity.EntityDrygmy;
import com.hollingsworth.arsnouveau.common.entity.EntityFlyingItem;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class CollectEssenceGoal
extends Goal {
    public EntityDrygmy drygmy;
    public LivingEntity target;
    public boolean complete;
    public boolean approached;
    public int timeChanneling;
    public int timePathing;

    public CollectEssenceGoal(EntityDrygmy drygmy) {
        this.drygmy = drygmy;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        return this.drygmy.channelCooldown <= 0 && this.drygmy.getHome() != null && !this.drygmy.getHome().isOff;
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        super.start();
        DrygmyTile tile = this.drygmy.getHome();
        if (tile == null) {
            return;
        }
        this.target = tile.getRandomEntity();
        this.complete = false;
        this.approached = false;
        this.timeChanneling = 0;
        this.timePathing = 0;
    }

    public boolean canContinueToUse() {
        return !this.complete && this.canUse() && this.target != null && !this.target.isRemoved() && this.target.isAlive();
    }

    public void tick() {
        super.tick();
        if (this.complete || this.target == null) {
            return;
        }
        if (this.approached) {
            this.drygmy.setChannelingEntity(this.target.getId());
            this.drygmy.getLookControl().setLookAt((Entity)this.target, 10.0f, (float)this.drygmy.getMaxHeadXRot());
            this.drygmy.getNavigation().stop();
            this.approached = true;
            this.drygmy.setChanneling(true);
            ++this.timeChanneling;
            if (this.timeChanneling >= 100) {
                this.drygmy.setChanneling(false);
                this.drygmy.setHoldingEssence(true);
                this.drygmy.setChannelingEntity(-1);
                this.complete = true;
                BlockPos homePos = this.drygmy.getHome().getBlockPos();
                BlockPos targetPos = this.target.blockPosition();
                if (homePos.getY() >= targetPos.getY() - 2) {
                    targetPos = targetPos.above(homePos.getY() - targetPos.getY());
                }
                EntityFlyingItem item = new EntityFlyingItem(this.drygmy.level, targetPos, homePos, 50, 255, 20);
                this.drygmy.level.addFreshEntity((Entity)item);
                this.drygmy.channelCooldown = 100;
                this.drygmy.getHome().giveProgress();
            }
        } else {
            if (this.timePathing > 160) {
                this.approached = true;
                this.drygmy.getNavigation().stop();
            }
            if (BlockUtil.distanceFrom(this.drygmy.position, this.target.position) <= 2.3) {
                this.approached = true;
            } else {
                ++this.timePathing;
                Path path = this.drygmy.getNavigation().createPath(this.target.getX(), this.target.getY(), this.target.getZ(), 1);
                if (path == null || !path.canReach()) {
                    this.approached = true;
                    this.drygmy.getNavigation().stop();
                } else {
                    this.drygmy.getNavigation().moveTo(path, 1.0);
                }
            }
        }
    }

    public void stop() {
        super.stop();
        this.complete = false;
        this.approached = false;
        this.drygmy.setChannelingEntity(-1);
        this.drygmy.setChanneling(false);
        this.timeChanneling = 0;
    }
}

