/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.chimera;

import com.hollingsworth.arsnouveau.api.event.ChimeraSummonEvent;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.WildenChimera;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketTimedEvent;
import java.util.EnumSet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class ChimeraSummonGoal
extends Goal {
    private WildenChimera mob;
    public int timeSummoning;
    public boolean done;
    public boolean howling;

    public ChimeraSummonGoal(WildenChimera boss) {
        this.mob = boss;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void start() {
        super.start();
        this.timeSummoning = 0;
        this.done = false;
        this.howling = false;
    }

    public boolean isInterruptable() {
        return false;
    }

    public boolean canContinueToUse() {
        return !this.done && !this.mob.getPhaseSwapping();
    }

    public boolean canUse() {
        return this.mob.canSummon() && !this.mob.isSwimming();
    }

    public void tick() {
        super.tick();
        if (!this.howling) {
            this.howling = true;
            this.mob.setHowling(true);
            ChimeraSummonEvent summonEvent = new ChimeraSummonEvent(40 + this.mob.getPhase() * 20, this.mob.getPhase(), this.mob.level, this.mob.blockPosition(), this.mob.getId());
            EventQueue.getServerInstance().addEvent(summonEvent);
            Networking.sendToNearbyClient(this.mob.level, (Entity)this.mob, (CustomPacketPayload)new PacketTimedEvent(summonEvent));
            this.mob.level.playSound(null, this.mob.blockPosition(), SoundEvents.WOLF_HOWL, SoundSource.HOSTILE, 1.0f, 0.2f);
        }
        ++this.timeSummoning;
        if (this.timeSummoning >= 80) {
            this.done = true;
            this.mob.summonCooldown = (int)(1000.0 + ParticleUtil.inRange(-100.0, 100.0) + (double)this.mob.getCooldownModifier());
            this.mob.setHowling(false);
        }
    }
}

